/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.pkcs.AuthenticatedAttributesUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.logging.LoggerManager;
import java.security.PublicKey;
import java.util.Arrays;

final class PKCS7AuthHelper {
    PKCS7AuthHelper() {
    }

    public static boolean sm2VerifySignAuthAttr(byte[] contentDigest, ASN1Set authAttributes, Session session, PublicKey pubKey, byte[] signature) throws Exception {
        boolean verifyResult = false;
        byte[] authAttributesDigest = AuthenticatedAttributesUtil.getMessageDigest(authAttributes);
        boolean verifyAuthAttributesDigest = Arrays.equals(contentDigest, authAttributesDigest);
        if (!verifyAuthAttributesDigest) {
            LoggerManager.exceptionLogger.error("sm2VerifySignAuthAttr failed: the Digest of SourceData is not equals with Digest in authAttributes!");
            verifyResult = false;
        } else {
            byte[] bAuthAttries = authAttributes.getEncoded();
            verifyResult = session.verify(Mechanisms.M_SM3_SM2, pubKey, bAuthAttries, signature);
        }
        return verifyResult;
    }

    public static boolean rsaVerifySignAuthAttr(Mechanism signM, byte[] contentDigest, ASN1Set authAttributes, Session session, PublicKey pubKey, byte[] signature) throws Exception {
        boolean verifyResult = false;
        byte[] authAttributesDigest = AuthenticatedAttributesUtil.getMessageDigest(authAttributes);
        boolean verifyAuthAttributesDigest = Arrays.equals(contentDigest, authAttributesDigest);
        if (!verifyAuthAttributesDigest) {
            LoggerManager.exceptionLogger.error("rsaVerifySignAuthAttr failed: the Digest of SourceData is not equals with Digest in authAttributes!");
            verifyResult = false;
        } else {
            byte[] bAuthAttries = authAttributes.getEncoded();
            verifyResult = session.verify(signM, pubKey, bAuthAttries, signature);
        }
        return verifyResult;
    }
}

