/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.IExtendECC;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardHashHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKeyHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import cfca.sadk.system.logging.LoggerManager;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;

public final class ECCCardDummy
implements IExtendECC {
    public KeyPair generateKeyPair(boolean isExport, int keyIndex, int keyUsage, int curveId) throws CryptoException {
        if (!isExport) {
            throw new CryptoException("ECCCardDummy do not support isExport=false");
        }
        String hexCurveId = NumberHelper.hex(curveId);
        ECCCurveId eccCurveId = ECCCurveId.findECCCurveId(curveId);
        if (eccCurveId == null) {
            LoggerManager.exceptionLogger.error("ECCCardDummy generateKeypair failure: invalid curveId={}", (Object)hexCurveId);
            throw new CryptoException("ECCCardDummy generateKeypair failure: invalid curveId=" + hexCurveId);
        }
        try {
            ECNamedCurveGenParameterSpec params = new ECNamedCurveGenParameterSpec(eccCurveId.getCurveName());
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("EC", Dummy.SADK_PROVIDER);
            keyPairGen.initialize(params, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            ECCCardPublicKey pubKey = new ECCCardPublicKey((BCECPublicKey)keyPair.getPublic(), curveId);
            ECCCardExternalPrivateKey priKey = new ECCCardExternalPrivateKey((BCECPrivateKey)keyPair.getPrivate(), curveId);
            return new KeyPair(pubKey, priKey);
        }
        catch (NoSuchAlgorithmException e) {
            LoggerManager.exceptionLogger.error("ECCCardDummy generateKeypair failure: NoSuchAlgorithm for curveId={}", (Object)hexCurveId);
            throw new CryptoException("ECCCardDummy generateKeypair failure: NoSuchAlgorithm for curveId=" + hexCurveId, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LoggerManager.exceptionLogger.error("ECCCardDummy generateKeypair failure:  InvalidAlgorithmParameter for curveId={}", (Object)hexCurveId);
            throw new CryptoException("ECCCardDummy generateKeypair failure: InvalidAlgorithmParameter for curveId=" + hexCurveId, e);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCardDummy generateKeypair failure: curveId={}", (Object)hexCurveId);
            throw new CryptoException("ECCCardDummy generateKeypair failure: curveId=" + NumberHelper.hex(curveId), e);
        }
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] hashValue) throws CryptoException {
        if (hashValue == null || hashValue.length == 0) {
            throw new CryptoParameterException("ECCCardDummy signByHash missing hashValue");
        }
        ECCCardExternalPrivateKey cardKey = ECCCardDummy.convertPrivateKey(privateKey);
        byte[] hashData = ECCCardHashHelper.formatHashData(cardKey, hashValue, false);
        byte[] signData = null;
        try {
            Signature ecdsaSigner = Signature.getInstance("NONEwithECDSA", Dummy.SADK_PROVIDER);
            ecdsaSigner.initSign(cardKey);
            ecdsaSigner.update(hashData);
            signData = ecdsaSigner.sign();
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCardDummy signByHash failure,hashValue={},privateKey={}", new Object[]{DataHelper.dump4KPartData(hashValue), cardKey.dumpPublicKey(), e});
            throw new CryptoException("ECCCardDummy signByHash failure", e);
        }
        return signData;
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] hashValue, byte[] signValue) throws CryptoException {
        if (hashValue == null || hashValue.length == 0) {
            throw new CryptoParameterException("ECCCardDummy verifyByHash missing hashValue");
        }
        if (signValue == null || signValue.length == 0) {
            throw new CryptoParameterException("ECCCardDummy verifyByHash missing signData");
        }
        ECCCardPublicKey cardKey = this.convertPublicKey(publicKey);
        byte[] hashData = ECCCardHashHelper.formatHashData(cardKey, hashValue, false);
        boolean operationResult = false;
        try {
            Signature ecdsaSigner = Signature.getInstance("NONEwithECDSA", Dummy.SADK_PROVIDER);
            ecdsaSigner.initVerify(cardKey);
            ecdsaSigner.update(hashData);
            operationResult = ecdsaSigner.verify(signValue);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCardDummy verifyByHash failure,hashValue={},privateKey={}", new Object[]{DataHelper.dump4KPartData(hashValue), cardKey.dumpPublicKey(), e});
            throw new CryptoException("ECCCardDummy verifyByHash failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("ECCCardDummy verifyByHash failure,operationResult={},hashValue={},privateKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(hashValue), cardKey.dumpPublicKey()});
            throw new CryptoException("ECCCardDummy verifyByHash failure: operationResult=" + operationResult);
        }
        return operationResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData, AlgorithmParameterSpec params) throws CryptoException {
        if (sourceData == null || sourceData.length == 0) {
            throw new CryptoParameterException("ECCCardDummy encrypt missing sourceData");
        }
        ECCCardPublicKey cardKey = this.convertPublicKey(publicKey);
        byte[] encryptData = null;
        boolean operationResult = false;
        try {
            Cipher cipher = Cipher.getInstance("ECIESwithAES-CBC", Dummy.SADK_PROVIDER);
            cipher.init(1, (Key)cardKey, params);
            encryptData = cipher.doFinal(sourceData);
            operationResult = true;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCardDummy encrypt failure,sourceDataLength={},publicKey={}", new Object[]{sourceData.length, cardKey.dumpPublicKey(), e});
            throw new CryptoException("ECCCardDummy encrypt failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("ECCCardDummy encrypt failure,operationResult={},sourceDataLength={},publicKey={}", new Object[]{operationResult, sourceData.length, cardKey.dumpPublicKey()});
            throw new CryptoException("ECCCardDummy encrypt failure: operationResult=" + operationResult);
        }
        return encryptData;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] eccEncryptData, AlgorithmParameterSpec params) throws CryptoException {
        if (eccEncryptData == null || eccEncryptData.length == 0) {
            throw new CryptoParameterException("ECCCardDummy decrypt missing eccEncryptData");
        }
        ECCCardExternalPrivateKey cardKey = ECCCardDummy.convertPrivateKey(privateKey);
        byte[] decryptData = null;
        boolean operationResult = false;
        try {
            Cipher cipher = Cipher.getInstance("ECIESwithAES-CBC", Dummy.SADK_PROVIDER);
            cipher.init(1, (Key)cardKey, params);
            decryptData = cipher.doFinal(eccEncryptData);
            operationResult = true;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("ECCCardDummy encrypt failure,encryptDataLength={},publicKey={}", new Object[]{eccEncryptData.length, cardKey.dumpPublicKey(), e});
            throw new CryptoException("ECCCardDummy encrypt failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("ECCCardDummy encrypt failure,operationResult={},encryptDataLength={},publicKey={}", new Object[]{operationResult, eccEncryptData.length, cardKey.dumpPublicKey()});
            throw new CryptoException("ECCCardDummy encrypt failure: operationResult=" + operationResult);
        }
        return decryptData;
    }

    private static final ECCCardExternalPrivateKey convertPrivateKey(PrivateKey privateKey) throws CryptoException {
        return (ECCCardExternalPrivateKey)ECCCardKeyHelper.buildPrivateKey(privateKey);
    }

    private final ECCCardPublicKey convertPublicKey(PublicKey publicKey) throws CryptoException {
        return (ECCCardPublicKey)ECCCardKeyHelper.buildPublicKey(publicKey);
    }

    public boolean checkIdleTest() throws CryptoException {
        return true;
    }

    public boolean idleTest() throws CryptoException {
        return true;
    }

    public int ensureKeyIndexValid(int keyIndex) throws CryptoException {
        return keyIndex;
    }

    public byte[] hash(Mechanism mechanism, byte[] sourceData) throws CryptoException {
        return ECCCardHashHelper.hash(mechanism, sourceData);
    }

    public byte[] hash(Mechanism mechanism, InputStream sourceStream) throws CryptoException {
        return ECCCardHashHelper.hash(mechanism, sourceStream);
    }

    public static class Dummy {
        public static final ECCCardDummy INSTANCE = new ECCCardDummy();
        private static final BouncyCastleProvider SADK_PROVIDER = new BouncyCastleProvider();
    }
}

