/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyPair;

public final class ECCCardLoggings {
    private ECCCardLoggings() {
    }

    static final String buildPrivateKeySignByHashFailedMessage(ECCCardKey eccKey, byte[] dataInput) {
        StringBuilder builder = new StringBuilder(128);
        if (eccKey != null && eccKey.isInternalKey()) {
            builder.append("ECCCard cardPrivateKeySignByHash");
        } else {
            builder.append("ECCCard cardPrivateKeySignByHash");
        }
        builder.append(" failure: ");
        if (eccKey != null) {
            builder.append(",keyIndex: ").append(eccKey.getKeyIndex());
            builder.append(",params: ").append(eccKey.dumpPublicKey());
        }
        builder.append(",dataInput: ").append(DataHelper.dump4KPartData(dataInput));
        return builder.toString();
    }

    static final String buildPublicKeyVerifyByHashFailedMessage(ECCCardKey eccKey, byte[] dataInput, byte[] signature) {
        StringBuilder builder = new StringBuilder(128);
        if (eccKey != null && eccKey.isInternalKey()) {
            builder.append("ECCCard cardPublicKeyInternalVerifyByHash");
        } else {
            builder.append("ECCCard cardPublicKeyExternalVerifyByHash");
        }
        builder.append(" failure: ");
        if (eccKey != null) {
            builder.append(",curveId: ").append((Object)eccKey.getCurveId());
            builder.append(",keyIndex: ").append(eccKey.getKeyIndex());
            builder.append(",keyParams: ").append(eccKey.dumpPublicKey());
        }
        builder.append(",dataInput: ").append(DataHelper.dump4KPartData(dataInput));
        builder.append(",signature: ").append(DataHelper.dump4KPartData(signature));
        return builder.toString();
    }

    static final StringBuilder buildKeyPairCheckFailed(StringBuilder builder, KeyPair keyPair) {
        if (keyPair != null) {
            builder.append("\nPrivateKey: ").append(keyPair.getPrivate());
            builder.append("\nPublicKey: ").append(keyPair.getPublic());
        } else {
            builder.append("\nkeyPair=null");
        }
        return builder;
    }

    static final void warningGenerateKeyPairFailed(boolean isExport, int bitLength, int keyIndex, int keyUsage, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("ECCCard generateKeyPair failure: ");
            builder.append("isExport=").append(isExport);
            builder.append(", bitLength=").append(bitLength);
            builder.append(", keyIndex=").append(keyIndex);
            builder.append(" , keyUsage=").append(keyUsage);
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warningSignByHashFailed(ECCCardKey eccKey, byte[] hashValue, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("ECCCard signByHash failure: ");
            builder.append(" eccKey=").append(eccKey);
            builder.append(", hashValue=").append(hashValue == null ? "" : DataHelper.dump4KPartData(hashValue));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warningVerifyByHashFailed(ECCCardKey eccKey, byte[] hashValue, byte[] signValue, int returnResult) {
        if (LoggerManager.exceptionLogger.isWarnEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("ECCCard verifyByHash failure: ");
            builder.append(" eccKey=").append(eccKey);
            builder.append(", hashValue=").append(DataHelper.dump4KPartData(hashValue));
            builder.append(", signValue=").append(DataHelper.dump4KPartData(signValue));
            builder.append(", returnResult=").append(NumberHelper.hex(returnResult));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.warn(warning);
        }
    }

    static final void warningVerifyByHashFailed(ECCCardKey eccKey, byte[] hashValue, byte[] signValue, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("ECCCard verifyByHash failure: ");
            builder.append(" eccKey=").append(eccKey);
            builder.append(", hashValue=").append(DataHelper.dump4KPartData(hashValue));
            builder.append(", signValue=").append(DataHelper.dump4KPartData(signValue));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warningEncryptFailed(ECCCardKey eccKey, byte[] sourceData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("ECCCard [PublicKeyOperation]encrypt failure: ");
            builder.append(" eccKey=").append(eccKey);
            builder.append(", sourceData=").append(sourceData == null ? "" : DataHelper.dump4KPartData(sourceData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    static final void warninDecryptFailed(ECCCardKey eccKey, byte[] encryptData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("ECCCard [PrivateKeyOperation]decrypt failure: ");
            builder.append(" eccKey=").append(eccKey);
            builder.append(", encryptData=").append(encryptData == null ? "" : DataHelper.dump4KPartData(encryptData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }
}

