/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.HashUtil;
import java.io.IOException;
import java.io.InputStream;

final class RSACardHashHelper {
    private RSACardHashHelper() {
    }

    static final byte[] hashDigestInfo(Mechanism mechanism, byte[] sourceData) throws CryptoException {
        if (mechanism == null) {
            throw new CryptoException("hashDigestInfo missing mechanism");
        }
        if (sourceData == null) {
            throw new CryptoException("hashDigestInfo missing sourceData");
        }
        try {
            return HashUtil.RSAHashMessageByJNI(sourceData, mechanism, true);
        }
        catch (Exception e) {
            throw new CryptoException("hashDigestInfo failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("hashDigestInfo failure", e);
        }
    }

    static final byte[] hashDigestInfo(Mechanism mechanism, InputStream sourceStream) throws CryptoException {
        if (mechanism == null) {
            throw new CryptoException("hashDigestInfo missing mechanism");
        }
        if (sourceStream == null) {
            throw new CryptoException("hashDigestInfo missing sourceStream");
        }
        try {
            return HashUtil.RSAHashFileByJNI(sourceStream, mechanism, true);
        }
        catch (Exception e) {
            throw new CryptoException("hashDigestInfo failure", e);
        }
        catch (Throwable e) {
            throw new CryptoException("hashDigestInfo failure", e);
        }
    }

    static final byte[] buildDigestInfo(Mechanism mechanism, byte[] hash) throws CryptoException {
        if (mechanism == null) {
            throw new CryptoException("buildDigestInfo missing mechanism");
        }
        if (hash == null) {
            throw new CryptoException("buildDigestInfo missing hash");
        }
        try {
            AlgorithmIdentifier algId = Mechanisms.getDigestAlgIdentifier(mechanism);
            if (algId == null) {
                algId = RSACardHashHelper.getRIPEMDIdentifier(mechanism);
            }
            if (algId == null) {
                throw new CryptoException("buildDigestInfo with invalid digest mechanism: " + mechanism);
            }
            DigestInfo dInfo = new DigestInfo(algId, hash);
            return dInfo.getEncoded("DER");
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CryptoException("buildDigestInfo Failure", e);
        }
    }

    private static final AlgorithmIdentifier getRIPEMDIdentifier(Mechanism mechanism) {
        ASN1ObjectIdentifier oid = null;
        if (mechanism == null || mechanism.getMechanismType() == null) {
            oid = null;
        } else {
            String type = mechanism.getMechanismType().toUpperCase();
            if (type.equals("RIPEMD128")) {
                oid = TeleTrusTObjectIdentifiers.ripemd128;
            } else if (type.equals("RIPEMD160")) {
                oid = TeleTrusTObjectIdentifiers.ripemd160;
            } else if (type.equals("RIPEMD256")) {
                oid = TeleTrusTObjectIdentifiers.ripemd256;
            }
        }
        AlgorithmIdentifier digestAlgIdentifier = null;
        if (oid != null) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, DERNull.INSTANCE);
        }
        return digestAlgIdentifier;
    }
}

