/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardInternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import cfca.sadk.system.logging.LoggerManager;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class SM2CardKeyHelper {
    private SM2CardKeyHelper() {
    }

    public static final PublicKey buildPublicKey(PublicKey publicKey) throws CryptoException {
        SM2CardPublicKey pubKey;
        if (publicKey == null) {
            throw new CryptoParameterException("SM2Card buildExternalPublicKey failure with null publicKey");
        }
        if (publicKey instanceof SM2CardPublicKey) {
            pubKey = (SM2CardPublicKey)publicKey;
        } else if (publicKey instanceof GMTPublicKey) {
            GMTPublicKey gmtKey = (GMTPublicKey)publicKey;
            pubKey = new SM2CardPublicKey(gmtKey.getPubXByBytes(), gmtKey.getPubYByBytes());
        } else {
            throw new CryptoException("SM2Card buildExternalPublicKey failure with not support key: " + publicKey.getClass());
        }
        return pubKey;
    }

    public static final GMTPublicKey buildExternalPublicKey(byte[] pubKeyData) throws CryptoException {
        if (pubKeyData == null) {
            throw new CryptoParameterException("SM2Card buildExternalPublicKey failure with null pubKeyData");
        }
        try {
            return SM2CardPublicKey.buildExternalKey(pubKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("SM2Card buildExternalPublicKey failure with invalid pubKeyData: {}", (Object)DataHelper.dump4KPartData(pubKeyData), (Object)e);
            }
            throw new CryptoException("SM2Card buildExternalPublicKey failure with invalid pubKeyData", e);
        }
    }

    public static final GMTPublicKey buildInternalPublicKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoParameterException("SM2Card buildInternalPublicKey failure with keyIndex=" + keyIndex);
        }
        if (pubKeyData == null) {
            throw new CryptoParameterException("SM2Card buildInternalPublicKey failure with null pubKeyData");
        }
        try {
            return SM2CardPublicKey.buildInternalKey(keyIndex, keyUsage, pubKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("SM2Card buildInternalPublicKey failure with invalid pubKeyData: {}, keyIndex={}", new Object[]{DataHelper.dump4KPartData(pubKeyData), keyIndex, e});
            }
            throw new CryptoException("SM2Card buildInternalPublicKey failure with invalid pubKeyData", e);
        }
    }

    public static final PrivateKey buildPrivateKey(PrivateKey privateKey) throws CryptoException {
        PrivateKey privKey;
        if (privateKey == null) {
            throw new CryptoParameterException("SM2Card buildExternalPrivateKey failure with null privateKey");
        }
        if (privateKey instanceof SM2CardExternalPrivateKey) {
            privKey = (SM2CardExternalPrivateKey)privateKey;
        } else if (privateKey instanceof SM2CardInternalPrivateKey) {
            privKey = (SM2CardInternalPrivateKey)privateKey;
        } else if (privateKey instanceof GMTPrivateKey) {
            GMTPrivateKey gmtKey = (GMTPrivateKey)privateKey;
            GMTPublicKey pubKey = gmtKey.getSM2PublicKey();
            privKey = new SM2CardExternalPrivateKey(gmtKey.getDByBytes(), pubKey.getPubXByBytes(), pubKey.getPubYByBytes());
        } else {
            throw new CryptoException("SM2Card buildExternalPrivateKey failure with not support key: " + privateKey.getClass());
        }
        return privKey;
    }

    public static final GMTPrivateKey buildExternalPrivateKey(byte[] priKeyData) throws CryptoException {
        if (priKeyData == null) {
            throw new CryptoParameterException("SM2Card buildExternalPrivateKey failure with null priKeyData");
        }
        try {
            return SM2CardExternalPrivateKey.buildExternalSoftKey(priKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("SM2Card buildExternalPrivateKey failure with invalid priKeyData: {}", (Object)DataHelper.dump4KPartData(priKeyData), (Object)e);
            }
            throw new CryptoException("SM2Card buildExternalPrivateKey failure with invalid priKeyData", e);
        }
    }

    public static final PrivateKey buildInternalPrivateKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoParameterException("SM2Card buildInternalPrivateKey failure with keyIndex=" + keyIndex);
        }
        if (pubKeyData == null) {
            throw new CryptoParameterException("SM2Card buildInternalPrivateKey failure with null pubKeyData");
        }
        try {
            return new SM2CardInternalPrivateKey(keyIndex, keyUsage, pubKeyData);
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                LoggerManager.exceptionLogger.error("SM2Card buildInternalPrivateKey failure with invalid pubKeyData: {}, keyIndex={}", new Object[]{DataHelper.dump4KPartData(pubKeyData), keyIndex, e});
            }
            throw new CryptoException("SM2Card buildInternalPrivateKey failure with invalid pubKeyData", e);
        }
    }

    static final String dumpPublicKey(GMTPrivateKey cardKey) {
        return cardKey == null ? "" : SM2CardKeyHelper.dumpPublicKey(cardKey.getSM2PublicKey());
    }

    static final String dumpPublicKey(GMTPublicKey cardKey) {
        return cardKey == null ? "" : SM2CardPublicKey.buildKeyInfo(cardKey.getPubX(), cardKey.getPubY(), cardKey.getDefaultZ());
    }
}

