/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.IRSACard;
import cfca.sadk.lib.crypto.card.c200r.C200ExternalRSAPrivateKey;
import cfca.sadk.lib.crypto.card.c200r.C200InternalRSAPrivateKey;
import cfca.sadk.lib.crypto.card.c200r.C200RSACardInfo;
import cfca.sadk.lib.crypto.card.c200r.C200RSACardLoginStat;
import cfca.sadk.lib.crypto.card.c200r.C200RSAInvalidKey;
import cfca.sadk.lib.crypto.card.c200r.C200RSAKey;
import cfca.sadk.lib.crypto.card.c200r.C200RSAKeyUtil;
import cfca.sadk.lib.crypto.card.c200r.C200RSAPublicKey;
import cfca.sadk.lib.crypto.card.c200r.RSAP1Decoder;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNISDF;
import java.io.File;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

public final class C200RSACard
implements IRSACard {
    static final Session SOFTLIB_SESSION = new BCSoftLib();
    private C200RSACardInfo cardInfo;
    private long sessionHandle;
    private JNISDF jnisdf;

    public final void initLib(Object param) throws CardException {
        if (param == null) {
            throw new CardParameterException("C200RSACard jnisdf.initLib rejected: missing param#cardInfo");
        }
        if (!(param instanceof C200RSACardInfo)) {
            throw new CardParameterException("C200RSACard jnisdf.initLib rejected:  param#cardInfo invalid-->" + param.getClass());
        }
        C200RSACardInfo cardInfo = (C200RSACardInfo)param;
        try {
            LoggerManager.systemLogger.info("C200RSACard>>>>>> init Running: info={}", (Object)cardInfo);
            File p11File = new File(cardInfo.sdfLibPath);
            if (!p11File.exists()) {
                throw new CardException("C200RSACard<<<<<<loadLib failure: " + p11File.getAbsolutePath() + " is not exists!");
            }
            if (!p11File.isFile()) {
                throw new CardException("C200RSACard<<<<<<loadLib failure: " + p11File.getAbsolutePath() + " is not file!");
            }
            JNISDF jnisdf = new JNISDF();
            jnisdf.loadSDFLib(cardInfo.sdfLibPath);
            LoggerManager.systemLogger.info("C200RSACard::::::loadLib successfully");
            long deviceHandle = jnisdf.openDevice();
            LoggerManager.systemLogger.info(String.format("C200RSACard::::::openDevice-->deviceHandle=0x%08x", deviceHandle));
            if (deviceHandle == 0L) {
                throw new CardException("C200RSACard<<<<<<openDevice failure: deviceHandle=0");
            }
            long sessionHandle = jnisdf.openSession(deviceHandle);
            LoggerManager.systemLogger.info(String.format("C200RSACard cardInitOpenSession::<<<<<<sessionHandle=0x%08x", sessionHandle));
            if (sessionHandle == 0L) {
                throw new CardException("C200RSACard openSession failure: sessionHandle=0");
            }
            byte[] pucStatus = new byte[]{0};
            int returnValue = jnisdf.getLoginStatus(sessionHandle, pucStatus);
            LoggerManager.systemLogger.info(String.format("C200RSACard::::::getLoginStatus and returnValue=0x%08x", returnValue));
            if (returnValue != 0) {
                String warning = String.format("C200RSACard::::::getLoginStatus and returnValue=0x%08x", returnValue);
                LoggerManager.systemLogger.error(warning);
                throw new CardException(warning);
            }
            if (pucStatus[0] != C200RSACardLoginStat.OPERATOR.status) {
                String warning = String.format("C200RSACard::::::getLoginStatus and returnValue=0x%08x", returnValue);
                LoggerManager.systemLogger.error(warning);
                throw new CardException(warning);
            }
            LoggerManager.systemLogger.info("C200RSACard::::::loginStatus is vaild for operator-role");
            this.cardInfo = cardInfo;
            this.sessionHandle = sessionHandle;
            this.jnisdf = jnisdf;
            LoggerManager.systemLogger.info("C200RSACard<<<<<<Init Successfully");
        }
        catch (CardException e) {
            LoggerManager.exceptionLogger.error("C200RSACard<<<<<<Init failure", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("C200RSACard<<<<<<Init failure", (Throwable)e);
            throw new CardException("C200RSACard init failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("C200RSACard<<<<<<Init failure", e);
            throw new CardException("C200RSACard init failure", e);
        }
    }

    public final KeyPair generateKeyPair(boolean isExport, int bitLength, int keyIndex, int keyUsage) throws CardException {
        KeyPair keyPair;
        try {
            keyPair = isExport ? this.generateExternalKeyPair(bitLength, this.sessionHandle) : this.generateInternalKeyPair(keyIndex, keyUsage, this.sessionHandle);
            this.checkKeyPair(keyPair);
        }
        catch (CardException e) {
            this.warningGenerateKeyPairFailed(isExport, bitLength, keyIndex, keyUsage, e);
            throw e;
        }
        catch (Exception e) {
            this.warningGenerateKeyPairFailed(isExport, bitLength, keyIndex, keyUsage, e);
            throw new CardException("C200RSACard generateKeyPair failure", e);
        }
        catch (Throwable e) {
            this.warningGenerateKeyPairFailed(isExport, bitLength, keyIndex, keyUsage, e);
            throw new CardException("C200RSACard generateKeyPair failure", e);
        }
        return keyPair;
    }

    public final byte[] signByHash(PrivateKey privateKey, byte[] hashWithAlgorithm) throws CardException {
        C200RSAKey privKey = C200RSAKeyUtil.buildC200RSAPrivateKey(privateKey);
        try {
            byte[] signData;
            if (privKey instanceof C200RSAInvalidKey) {
                signData = RSAPackageUtil.encrypt(hashWithAlgorithm, privateKey);
            } else {
                byte[] dataInput = RSAP1Decoder.addPKCS1Padding(hashWithAlgorithm, privKey.modulusByteLength(), true);
                signData = this.cardPrivateKeyOperationRSA(this.sessionHandle, privKey, dataInput);
            }
            return signData;
        }
        catch (CardException e) {
            this.warningSignByHashFailed(privKey, hashWithAlgorithm, e);
            throw e;
        }
        catch (Exception e) {
            this.warningSignByHashFailed(privKey, hashWithAlgorithm, e);
            throw new CardException("C200RSACard signByHash failure", e);
        }
        catch (Throwable e) {
            this.warningSignByHashFailed(privKey, hashWithAlgorithm, e);
            throw new CardException("C200RSACard signByHash failure", e);
        }
    }

    public final boolean verifyByHash(PublicKey publicKey, byte[] hashWithAlgorithm, byte[] signedData) throws CardException {
        boolean verifyResult;
        C200RSAKey pubKey = C200RSAKeyUtil.buildC200RSAPublicKey(publicKey);
        int modulusLength = pubKey.modulusByteLength();
        try {
            byte[] dataOutput = this.cardPublicKeyOperationRSA(this.sessionHandle, pubKey, signedData);
            byte[] decryptDigestInfo = RSAP1Decoder.delPKCS1Padding(dataOutput, modulusLength, true);
            verifyResult = Arrays.equals(decryptDigestInfo, hashWithAlgorithm);
            if (!verifyResult && LoggerManager.exceptionLogger.isWarnEnabled()) {
                StringBuilder builder = new StringBuilder(1024);
                builder.append("C200RSACard verifyByHash failure: ");
                builder.append("\n hashWithAlgorithm: 0x").append(Hex.toHexString(hashWithAlgorithm));
                builder.append("\n signedData: 0x").append(Hex.toHexString(signedData));
                builder.append("\n publicKey: ").append(publicKey);
                String warnning = builder.toString();
                LoggerManager.exceptionLogger.warn(warnning);
            }
        }
        catch (CardException e) {
            this.warningVerifyByHashFailed(pubKey, hashWithAlgorithm, e);
            throw e;
        }
        catch (Exception e) {
            this.warningVerifyByHashFailed(pubKey, hashWithAlgorithm, e);
            throw new CardException("C200RSACard verifyByHash failure", e);
        }
        catch (Throwable e) {
            this.warningVerifyByHashFailed(pubKey, hashWithAlgorithm, e);
            throw new CardException("C200RSACard verifyByHash failure", e);
        }
        return verifyResult;
    }

    public final byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CardException {
        C200RSAKey pubKey = C200RSAKeyUtil.buildC200RSAPublicKey(publicKey);
        try {
            byte[] dataInput = RSAP1Decoder.addPKCS1Padding(sourceData, pubKey.modulusByteLength(), false);
            return this.cardPublicKeyOperationRSA(this.sessionHandle, pubKey, dataInput);
        }
        catch (CardException e) {
            this.warningEncryptFailed(pubKey, sourceData, e);
            throw e;
        }
        catch (Exception e) {
            this.warningEncryptFailed(pubKey, sourceData, e);
            throw new CardException("C200RSACard  [PublicKeyOperation]encrypt failure", e);
        }
        catch (Throwable e) {
            this.warningEncryptFailed(pubKey, sourceData, e);
            throw new CardException("C200RSACard  [PublicKeyOperation]encrypt failure", e);
        }
    }

    public final byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CardException {
        C200RSAKey privKey = C200RSAKeyUtil.buildC200RSAPrivateKey(privateKey);
        try {
            byte[] decryptData;
            if (privKey instanceof C200RSAInvalidKey) {
                decryptData = SOFTLIB_SESSION.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), privateKey, encryptData);
            } else {
                byte[] dataOutput = this.cardPrivateKeyOperationRSA(this.sessionHandle, privKey, encryptData);
                decryptData = RSAP1Decoder.delPKCS1Padding(dataOutput, privKey.modulusByteLength(), false);
            }
            return decryptData;
        }
        catch (CardException e) {
            this.warninDecryptFailed(privKey, encryptData, e);
            throw e;
        }
        catch (Exception e) {
            this.warninDecryptFailed(privKey, encryptData, e);
            throw new CardException("C200RSACard  [PrivateKeyOperation]decrypt failure", e);
        }
        catch (Throwable e) {
            this.warninDecryptFailed(privKey, encryptData, e);
            throw new CardException("C200RSACard  [PrivateKeyOperation]decrypt failure", e);
        }
    }

    public final void unInitLib(Object param) {
        this.sessionHandle = 0L;
        if (this.jnisdf != null) {
            try {
                LoggerManager.systemLogger.info("C200RSACard>>>>>>unloadLib Running: info={}", (Object)this.cardInfo);
                this.jnisdf.unloadLib();
                LoggerManager.systemLogger.info("C200RSACard<<<<<<unloadLib Finished");
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("C200RSACard<<<<<<uninit failure", (Throwable)e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("C200RSACard<<<<<<uninit failure", e);
            }
        }
    }

    private final boolean checkKeyPair(KeyPair keyPair) throws CardException {
        String sha256Header = "3031300d060960864801650304020105000420";
        String sha256Value = "45f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb";
        byte[] hashValue = Hex.decode("45f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb");
        byte[] hashWithAlgorithm = Hex.decode("3031300d06096086480165030402010500042045f70cf58f607e6d891c93f594f1826ffb3a0ddea7d2a0753b0c110836d6aecb");
        byte[] signData = this.signByHash(keyPair.getPrivate(), hashWithAlgorithm);
        try {
            this.verifyByHashWithCard(keyPair, hashWithAlgorithm, signData);
            this.verifyByHashWithSoft(keyPair, hashValue, signData);
        }
        catch (Exception e) {
            String message = "C200RSACard generateKeyPair: check keypair failure: " + this.buildKeyPairCheckFailed(keyPair);
            LoggerManager.exceptionLogger.error(message, (Throwable)e);
            throw new CardException("C200RSACard generateKeyPair: check keypair failure", e);
        }
        return true;
    }

    private final boolean verifyByHashWithCard(KeyPair keyPair, byte[] hashWithAlgorithm, byte[] signData) throws CardException {
        boolean verifyResult = this.verifyByHash(keyPair.getPublic(), hashWithAlgorithm, signData);
        if (!verifyResult) {
            throw new CardException("verifyByHashWithCard return False");
        }
        return verifyResult;
    }

    private final boolean verifyByHashWithSoft(KeyPair keyPair, byte[] hashValue, byte[] signData) throws CardException, PKIException {
        boolean verifyResult = SOFTLIB_SESSION.verifyByHash(new Mechanism("sha256WithRSAEncryption"), keyPair.getPublic(), hashValue, signData);
        if (!verifyResult) {
            throw new CardException("verifyByHashWithSoft return False");
        }
        return verifyResult;
    }

    private final KeyPair generateExternalKeyPair(int modulusBitsLength, long sessionHandle) throws CardException {
        if (sessionHandle == 0L) {
            throw new CardException("C200RSACard jnisdf.generateKeyPairRSA rejected with sessionHandle=0 ");
        }
        if (modulusBitsLength != 1024 && modulusBitsLength != 2048 && modulusBitsLength != 4096) {
            throw new CardException("C200RSACard jnisdf.generateKeyPairRSA rejected with invalid bitLength=" + modulusBitsLength);
        }
        byte[] pubKeyData = new byte[1028];
        byte[] priKeyData = new byte[2820];
        try {
            int returnValue = this.jnisdf.generateKeyPairRSA(sessionHandle, modulusBitsLength, pubKeyData, priKeyData);
            if (returnValue != 0) {
                throw new CardException(String.format("jnisdf.generateKeyPairRSA returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("C200RSACard jnisdf.generateKeyPairRSA failure", (Throwable)e);
            throw new CardException("C200RSACard jnisdf.generateKeyPairRSA failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("C200RSACard jnisdf.generateKeyPairRSA failure", e);
            throw new CardException("C200RSACard jnisdf.generateKeyPairRSA failure", e);
        }
        C200RSAPublicKey publicKey = C200RSAPublicKey.buildExtervalSoftKey(pubKeyData);
        C200ExternalRSAPrivateKey privateKey = new C200ExternalRSAPrivateKey(priKeyData);
        return new KeyPair(publicKey, privateKey);
    }

    private final KeyPair generateInternalKeyPair(int keyIndex, int keyUsage, long sessionHandle) throws CardException {
        if (sessionHandle == 0L) {
            throw new CardException("C200RSACard generateInternalKeyPair rejected with sessionHandle=0");
        }
        if (keyIndex < this.cardInfo.minKeyIndex || keyIndex > this.cardInfo.maxKeyIndex) {
            throw new CardException("C200RSACard generateInternalKeyPair rejected with keyIndex=" + keyIndex);
        }
        if (keyUsage != 1 && keyUsage != 2) {
            throw new CardException("C200RSACard generateInternalKeyPair rejected with keyUsage=" + keyUsage);
        }
        byte[] pubKeyData = new byte[1028];
        try {
            int returnValue = this.jnisdf.exportPublicKeyRSA(sessionHandle, keyIndex, keyUsage, pubKeyData);
            if (returnValue != 0) {
                throw new CardException(String.format("jnisdf.exportPublicKeyRSA returnValue=0x%08x", returnValue));
            }
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("C200RSACard jnisdf.generateKeyPairRSAEx failure", (Throwable)e);
            throw new CardException("C200RSACard jnisdf.exportPublicKeyRSA failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("C200RSACard jnisdf.generateKeyPairRSAEx failure", e);
            throw new CardException("C200RSACard jnisdf.exportPublicKeyRSA failure", e);
        }
        C200RSAPublicKey publicKey = C200RSAPublicKey.buildIntervalHardKey(keyIndex, pubKeyData);
        C200InternalRSAPrivateKey privateKey = new C200InternalRSAPrivateKey(keyIndex, pubKeyData);
        return new KeyPair(publicKey, privateKey);
    }

    private final byte[] cardPrivateKeyOperationRSA(long sessionHandle, C200RSAKey rsaKey, byte[] dataInput) throws CardException {
        if (rsaKey == null) {
            throw new CardParameterException("C200RSACard cardPrivateKeyOperationRSA rejected: rsaKey = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CardParameterException("C200RSACard cardPrivateKeyOperationRSA rejected: encryptData = null ");
        }
        int moduleLength = rsaKey.modulusByteLength();
        if (dataInput.length != moduleLength) {
            throw new CardParameterException("C200RSACard cardPrivateKeyOperationRSA rejected:  dataInputLength= " + dataInput.length + ",moduleLength=" + moduleLength);
        }
        if (sessionHandle == 0L) {
            throw new CardException("C200RSACard cardPrivateKeyOperationRSA rejected with sessionHandle=0 ");
        }
        int[] dataOutputSize = new int[]{0};
        byte[] dataOutput = new byte[dataInput.length];
        try {
            if (rsaKey.isHardKey()) {
                int keyIndex = rsaKey.getKeyIndex();
                if (keyIndex < this.cardInfo.minKeyIndex || keyIndex > this.cardInfo.maxKeyIndex) {
                    throw new CardException("jnisdf.internalPrivateKeyOperationRSA rejected with keyIndex=" + keyIndex);
                }
                int returnValue = this.jnisdf.internalPrivateKeyOperationRSA(sessionHandle, keyIndex, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CardException(String.format("jnisdf.internalPrivateKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            } else {
                byte[] priKeyData = rsaKey.keyData();
                int returnValue = this.jnisdf.externalPrivateKeyOperationRSA(sessionHandle, priKeyData, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CardException(String.format("jnisdf.externalPrivateKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = this.buildPrivateKeyOperationRSAFailedMessage(sessionHandle, rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("C200RSACard cardPrivateKeyOperationRSA failure", (Throwable)e);
            throw new CardException(message, e);
        }
        catch (Throwable e) {
            String message = this.buildPrivateKeyOperationRSAFailedMessage(sessionHandle, rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("C200RSACard cardPrivateKeyOperationRSA failure", e);
            throw new CardException(message, e);
        }
        if (dataOutputSize[0] != dataOutput.length) {
            throw new CardException("C200RSACard cardPrivateKeyOperationRSA failure with dataOutputSize!=modulusBitsLength");
        }
        return dataOutput;
    }

    private final byte[] cardPublicKeyOperationRSA(long sessionHandle, C200RSAKey rsaKey, byte[] dataInput) throws CardException {
        if (rsaKey == null) {
            throw new CardParameterException("C200RSACard cardPublicKeyOperationRSA rejected: rsaKey = null");
        }
        if (dataInput == null || dataInput.length == 0) {
            throw new CardParameterException("C200RSACard cardPublicKeyOperationRSA rejected: encryptData = null");
        }
        int moduleLength = rsaKey.modulusByteLength();
        if (dataInput.length != moduleLength) {
            throw new CardParameterException("C200RSACard cardPublicKeyOperationRSA rejected:  dataInputLength= " + dataInput.length + ",moduleLength=" + moduleLength);
        }
        if (sessionHandle == 0L) {
            throw new CardException("C200RSACard cardPublicKeyOperationRSA rejected with sessionHandle=0 ");
        }
        byte[] dataOutput = new byte[dataInput.length];
        int[] dataOutputSize = new int[]{0};
        try {
            if (rsaKey.isHardKey()) {
                int keyIndex = rsaKey.getKeyIndex();
                if (keyIndex < this.cardInfo.minKeyIndex || keyIndex > this.cardInfo.maxKeyIndex) {
                    throw new CardException(String.format("jnisdf.internalPublicKeyOperationRSA rejected with keyIndex=%s, acceptedIndex[%s, %s]", keyIndex, this.cardInfo.minKeyIndex, this.cardInfo.maxKeyIndex));
                }
                int returnValue = this.jnisdf.internalPublicKeyOperationRSA(sessionHandle, rsaKey.getKeyIndex(), dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CardException(String.format("jnisdf.internalPublicKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            } else {
                byte[] pubKeyData = rsaKey.keyData();
                int returnValue = this.jnisdf.externalPublicKeyOperationRSA(sessionHandle, pubKeyData, dataInput, dataOutput, dataOutputSize);
                if (returnValue != 0) {
                    throw new CardException(String.format("jnisdf.externalPublicKeyOperationRSA returnValue=0x%08x", returnValue));
                }
            }
        }
        catch (Exception e) {
            String message = this.buildPublicKeyOperationRSAFailedMessage(sessionHandle, rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("C200RSACard cardPublicKeyOperationRSA failure", (Throwable)e);
            throw new CardException(message, e);
        }
        catch (Throwable e) {
            String message = this.buildPublicKeyOperationRSAFailedMessage(sessionHandle, rsaKey, dataInput);
            LoggerManager.exceptionLogger.error("C200RSACard cardPublicKeyOperationRSA failure", e);
            throw new CardException(message, e);
        }
        if (dataOutputSize[0] != dataOutput.length) {
            throw new CardException("C200RSACard cardPublicKeyOperationRSA failure with dataOutputSize!=modulusBitsLength");
        }
        return dataOutput;
    }

    private final String buildPrivateKeyOperationRSAFailedMessage(long sessionHandle, C200RSAKey rsaKey, byte[] dataInput) {
        StringBuilder builder = new StringBuilder(128);
        if (rsaKey != null && rsaKey.isHardKey()) {
            builder.append("C200RSACard jnisdf.internalPrivateKeyOperationRSA");
        } else {
            builder.append("C200RSACard jnisdf.externalPrivateKeyOperationRSA");
        }
        builder.append("failure: ");
        builder.append("sessionHandle: ").append(sessionHandle);
        if (rsaKey != null) {
            builder.append("keyIndex: ").append(rsaKey.getKeyIndex());
            builder.append("params: ").append(rsaKey.dumpPublicKey());
        }
        builder.append("dataInput: ").append(Hex.toHexString(dataInput));
        return builder.toString();
    }

    private final String buildPublicKeyOperationRSAFailedMessage(long sessionHandle, C200RSAKey rsaKey, byte[] dataInput) {
        StringBuilder builder = new StringBuilder(128);
        if (rsaKey != null && rsaKey.isHardKey()) {
            builder.append("C200RSACard jnisdf.internalPublicKeyOperationRSA");
        } else {
            builder.append("C200RSACard jnisdf.externalPublicKeyOperationRSA");
        }
        builder.append("failure: ");
        builder.append("sessionHandle: ").append(sessionHandle);
        if (rsaKey != null) {
            builder.append("keyIndex: ").append(rsaKey.getKeyIndex());
            builder.append("params: ").append(rsaKey.dumpPublicKey());
        }
        builder.append("dataInput: ").append(Hex.toHexString(dataInput));
        return builder.toString();
    }

    private final String buildKeyPairCheckFailed(KeyPair keyPair) {
        StringBuilder builder = new StringBuilder(128);
        builder.append("\nkeyPair=");
        if (keyPair != null) {
            builder.append("\nPrivateKey: ").append(keyPair.getPrivate());
            builder.append("\nPublicKey: ").append(keyPair.getPublic());
        } else {
            builder.append("null");
        }
        return builder.toString();
    }

    private final void warningGenerateKeyPairFailed(boolean isExport, int bitLength, int keyIndex, int keyUsage, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("C200RSACard generateKeyPair failure: ");
            builder.append("isExport=").append(isExport);
            builder.append(", bitLength=").append(bitLength);
            builder.append(", keyIndex=").append(isExport);
            builder.append(" , keyUsage=").append(keyUsage);
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    private final void warningSignByHashFailed(C200RSAKey privateKey, byte[] hashWithAlgorithm, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("C200RSACard signByHash failure: ");
            builder.append(" privateKey=").append(privateKey);
            builder.append(", hashWithAlgorithm=").append(hashWithAlgorithm == null ? "" : Hex.toHexString(hashWithAlgorithm));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    private final void warningVerifyByHashFailed(C200RSAKey publicKey, byte[] hashWithAlgorithm, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("C200RSACard verifyByHash failure: ");
            builder.append(" publicKey=").append(publicKey);
            builder.append(", hashWithAlgorithm=").append(Hex.toHexString(hashWithAlgorithm));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    private final void warningEncryptFailed(C200RSAKey publicKey, byte[] sourceData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("C200RSACard [PublicKeyOperation]encrypt failure: ");
            builder.append(" publicKey=").append(publicKey);
            builder.append(", sourceData=").append(sourceData == null ? "" : Hex.toHexString(sourceData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    private final void warninDecryptFailed(C200RSAKey privateKey, byte[] encryptData, Throwable e) {
        if (LoggerManager.exceptionLogger.isErrorEnabled()) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("C200RSACard [PrivateKeyOperation]decrypt failure: ");
            builder.append(" privateKey=").append(privateKey);
            builder.append(", encryptData=").append(encryptData == null ? "" : Hex.toHexString(encryptData));
            String warning = builder.toString();
            LoggerManager.exceptionLogger.error(warning, e);
        }
    }

    public boolean checkIdleTest() throws CardException {
        return true;
    }
}

