/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.aop;

import cn.com.yusys.yusp.cmis.commons.uitls.OcaTranslatorUtils;
import cn.com.yusys.yusp.commons.mapper.domain.BaseDomain;
import cn.com.yusys.yusp.commons.module.adapter.web.rest.ResultDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class UserAndOrgNameAspect {
    private static final Logger log = LoggerFactory.getLogger(UserAndOrgNameAspect.class);
    private static final HashSet<String> USER_SET = new HashSet();
    private static final HashSet<String> ORG_SET = new HashSet();
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public UserAndOrgNameAspect() {
        this.init();
    }

    public void init() {
        USER_SET.add("inputId");
        USER_SET.add("managerId");
        USER_SET.add("updId");
        USER_SET.add("bizRightsAarBrId");
        USER_SET.add("handoverId");
        USER_SET.add("receiverId");
        USER_SET.add("prcId");
        USER_SET.add("huser");
        USER_SET.add("mainMgr");
        USER_SET.add("lastUpdateId");
        USER_SET.add("marId");
        USER_SET.add("outId");
        ORG_SET.add("mainBrId");
        ORG_SET.add("inputBrId");
        ORG_SET.add("managerBrId");
        ORG_SET.add("updBrId");
        ORG_SET.add("belgOrg");
        ORG_SET.add("handOrg");
        ORG_SET.add("receiverOrg");
        ORG_SET.add("handoverBrId");
        ORG_SET.add("receiverBrId");
        ORG_SET.add("bizRightsAarBrIdOrg");
        ORG_SET.add("lastUpdateBrId");
        ORG_SET.add("aptiLiceRegiOrg");
        ORG_SET.add("finaBrNo");
        ORG_SET.add("managerBrNo");
        ORG_SET.add("orgId");
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void pointCut() {
    }

    @AfterReturning(returning="rvt", pointcut="pointCut()")
    public Object translate(Object rvt) {
        if (rvt instanceof ResultDto) {
            try {
                List list;
                ResultDto resultDto = (ResultDto)rvt;
                Object data = resultDto.getData();
                if (data instanceof List && !(list = (List)data).isEmpty()) {
                    this.dealList(list);
                }
                if (data instanceof BaseDomain) {
                    this.dealDomain((ResultDto<Object>)resultDto);
                }
            }
            catch (Exception e) {
                log.warn("\u673a\u6784\u7528\u6237\u7ffb\u8bd1\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        return rvt;
    }

    public void dealDomain(ResultDto<Object> resultDto) {
        Object domain = resultDto.getData();
        HashSet<String> user = new HashSet<String>();
        HashSet<String> orgs = new HashSet<String>();
        this.getUserAndOrgkeys(domain, user, orgs);
        Map<String, String> orgsDict = new HashMap<String, String>(16);
        HashMap<String, String> namesDict = new HashMap(16);
        if (!user.isEmpty()) {
            namesDict = this.getObjIdCode(domain, user).stream().collect(Collectors.toMap(code -> code, OcaTranslatorUtils::getUserName));
        }
        if (!orgs.isEmpty()) {
            orgsDict = this.getObjIdCode(domain, orgs).stream().collect(Collectors.toMap(code -> code, OcaTranslatorUtils::getOrgName));
        }
        if (!user.isEmpty() || !orgs.isEmpty()) {
            this.domainTrans(domain, resultDto, user, orgs, namesDict, orgsDict);
        }
    }

    private void domainTrans(Object domain, ResultDto<Object> resultDto, HashSet<String> user, HashSet<String> orgs, Map<String, String> namesDict, Map<String, String> orgsDict) {
        Map map = (Map)this.objectMapper.convertValue(domain, Map.class);
        for (String key : user) {
            String userCode = Objects.toString(map.get(key));
            if (userCode.contains(",")) {
                String[] arr = userCode.split(",");
                StringBuilder sb = new StringBuilder();
                for (String s : arr) {
                    sb.append(Optional.ofNullable(namesDict.get(s)).orElse(s));
                    sb.append(",");
                }
                map.put(key + "Name", sb.substring(0, sb.length() - 1));
                continue;
            }
            map.put(key + "Name", Optional.ofNullable(namesDict.get(userCode)).orElse(userCode));
        }
        for (String key : orgs) {
            map.put(key + "Name", Optional.ofNullable(orgsDict.get(map.get(key))).orElse(Objects.toString(map.get(key))));
        }
        resultDto.setData((Object)map);
    }

    public void dealList(List<Object> list) {
        Object item = list.get(0);
        HashSet<String> user = new HashSet<String>();
        HashSet<String> orgs = new HashSet<String>();
        this.getUserAndOrgkeys(item, user, orgs);
        Map<String, String> orgsDict = null;
        Map<String, String> namesDict = null;
        if (!user.isEmpty()) {
            namesDict = this.getCodeList(list, user).stream().collect(Collectors.toMap(code -> code, OcaTranslatorUtils::getUserName));
        }
        if (!orgs.isEmpty()) {
            orgsDict = this.getCodeList(list, orgs).stream().collect(Collectors.toMap(code -> code, OcaTranslatorUtils::getOrgName));
        }
        if (orgsDict != null || namesDict != null) {
            List<Map<String, Object>> result = this.listTrans(list, user, orgs, namesDict, orgsDict);
            list.clear();
            list.addAll(result);
        }
    }

    private List<Map<String, Object>> listTrans(List<Object> list, HashSet<String> user, HashSet<String> orgs, Map<String, String> namesDict, Map<String, String> orgsDict) {
        return list.stream().map(obj -> {
            Map map3 = (Map)this.objectMapper.convertValue(obj, Map.class);
            for (String key : user) {
                String userCode = Objects.toString(map3.get(key));
                if (userCode.contains(",")) {
                    String[] arr = userCode.split(",");
                    StringBuilder sb = new StringBuilder();
                    for (String s : arr) {
                        sb.append(Optional.ofNullable(namesDict.get(s)).orElse(s));
                        sb.append(",");
                    }
                    map3.put(key + "Name", sb.substring(0, sb.length() - 1));
                    continue;
                }
                map3.put(key + "Name", Optional.ofNullable(namesDict.get(userCode)).orElse(userCode));
            }
            for (String key : orgs) {
                map3.put(key + "Name", Optional.ofNullable(orgsDict.get(map3.get(key))).orElse(Objects.toString(map3.get(key))));
            }
            return map3;
        }).collect(Collectors.toList());
    }

    private void getUserAndOrgkeys(Object item, HashSet<String> user, HashSet<String> orgs) {
        if (item instanceof Map) {
            this.dealMap(((Map)item).keySet(), user, orgs);
        } else {
            Field[] fields;
            for (Field field : fields = item.getClass().getDeclaredFields()) {
                if (USER_SET.contains(field.getName())) {
                    user.add(field.getName());
                }
                if (!ORG_SET.contains(field.getName())) continue;
                orgs.add(field.getName());
            }
        }
    }

    private void dealMap(Set<Object> keySet, HashSet<String> user, HashSet<String> orgs) {
        for (Object o : keySet) {
            String name = Objects.toString(o);
            if (USER_SET.contains(name)) {
                user.add(name);
            }
            if (!ORG_SET.contains(name)) continue;
            orgs.add(name);
        }
    }

    public List<String> getCodeList(List<Object> list, Set<String> keySet) {
        return list.stream().map(obj -> this.getObjIdCode(obj, keySet)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public Set<String> getObjIdCode(Object obj, Set<String> keySet) {
        HashSet<String> res = new HashSet<String>();
        keySet.forEach(field -> {
            String getMethod = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
            try {
                String code = obj instanceof Map ? Optional.ofNullable(((Map)obj).get(field)).orElse("").toString() : Optional.ofNullable(obj.getClass().getDeclaredMethod(getMethod, new Class[0]).invoke(obj, new Object[0])).orElse("").toString();
                String separator = ",";
                if (code.contains(separator)) {
                    res.addAll(Arrays.asList(code.split(",")));
                } else {
                    res.add(code);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u62a5\u9519", (Throwable)e);
            }
        });
        return res;
    }
}

