/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.intercept;

import cn.com.yusys.yusp.annotation.SeqId;
import cn.com.yusys.yusp.commons.session.user.User;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.sequence.client.SequenceTemplateService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
@Component
public class ZrcbankIntercept
implements Interceptor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ZrcbankIntercept.class);
    private ApplicationContext applicationContext;

    public Object intercept(Invocation invocation) throws Throwable {
        Set<Object> set;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        User userInfo = SessionUtils.getUserInformation();
        if ("INSERT".equalsIgnoreCase(mappedStatement.getSqlCommandType().name())) {
            set = this.getEntitySet(args[1]);
            for (Object obj : set) {
                Field[] fields;
                for (Field field : fields = obj.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!field.isAnnotationPresent(SeqId.class) || field.get(obj) != null && !"".equals(field.get(obj))) continue;
                    SeqId seqId = field.getAnnotation(SeqId.class);
                    SequenceTemplateService sequenceTemplateService = (SequenceTemplateService)this.applicationContext.getBean(SequenceTemplateService.class);
                    String pkId = sequenceTemplateService.getSequenceTemplate(seqId.value(), new HashMap(1));
                    field.set(obj, pkId);
                }
                if (Objects.isNull(userInfo)) {
                    if (log.isDebugEnabled()) {
                        log.debug("userInfo is null,can't set inputId and inputBrId");
                    }
                } else {
                    this.setField(obj, "inputId", userInfo.getLoginCode());
                    this.setField(obj, "inputBrId", userInfo.getOrg().getCode());
                    this.setField(obj, "managerId", userInfo.getLoginCode());
                    this.setField(obj, "managerBrId", userInfo.getOrg().getCode());
                }
                this.setField(obj, "createTime", DateUtils.getCurrDate());
                this.setField(obj, "inputDate", DateUtils.getCurrDateStr());
            }
        }
        if ("INSERT".equalsIgnoreCase(mappedStatement.getSqlCommandType().name()) || "UPDATE".equalsIgnoreCase(mappedStatement.getSqlCommandType().name())) {
            set = this.getEntitySet(args[1]);
            for (Object obj : set) {
                if (Objects.isNull(userInfo)) {
                    if (log.isDebugEnabled()) {
                        log.debug("userInfo is null,can't set updId and updBrId");
                    }
                } else {
                    this.setField(obj, "updId", userInfo.getLoginCode());
                    this.setField(obj, "updBrId", userInfo.getOrg().getCode());
                }
                this.setField(obj, "updDate", DateUtils.getCurrDate());
                this.setField(obj, "updateTime", DateUtils.getCurrDate());
            }
        }
        return invocation.proceed();
    }

    public void setField(Object obj, String name, Object value) {
        Field field = null;
        try {
            field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            if (field.get(obj) == null || "".equals(field.get(obj))) {
                field.set(obj, value);
            }
        }
        catch (IllegalArgumentException e) {
            try {
                field.set(obj, DateUtils.formatDate((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e1) {}
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            // empty catch block
        }
    }

    private Set<Object> getEntitySet(Object obj) {
        HashSet<Object> set = new HashSet<Object>();
        if (obj instanceof Map) {
            if (((Map)obj).containsKey("list")) {
                Collection values = (Collection)((Map)obj).get("list");
                for (Object value : values) {
                    if (value instanceof Collection) {
                        set.addAll((Collection)value);
                        continue;
                    }
                    set.add(value);
                }
            } else if (((Map)obj).containsKey("collection")) {
                Collection values = (Collection)((Map)obj).get("collection");
                for (Object value : values) {
                    if (value instanceof Collection) {
                        set.addAll((Collection)value);
                        continue;
                    }
                    set.add(value);
                }
            }
        } else {
            set.add(obj);
        }
        return set;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

