/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.util;

import cn.com.yusys.yusp.commons.module.adapter.exception.YuspException;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.enums.returncode.EcbEnum;
import cn.com.yusys.yusp.flow.api.WorkflowCoreClient;
import cn.com.yusys.yusp.flow.dto.NextNodeInfoDto;
import cn.com.yusys.yusp.flow.dto.WFException;
import cn.com.yusys.yusp.flow.dto.result.ResultInstanceDto;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BizCommonUtils {
    private static BizCommonUtils bizCommonUtils;
    @Autowired
    private WorkflowCoreClient workflowCoreClient;
    @Autowired
    private AmqpTemplate amqpTemplate;

    public static boolean isFirstNodeCheck(ResultInstanceDto resultInstanceDto) {
        NextNodeInfoDto nextNodeInfoDto;
        boolean checkFlag = false;
        List nextNodeUserInfo = resultInstanceDto.getNextNodeInfos();
        if (CollectionUtils.isEmpty((Collection)nextNodeUserInfo)) {
            throw new YuspException(EcbEnum.BIZWORKFLOW_GETNEXTNODEINFONULL_EXCEPTION.key, EcbEnum.BIZWORKFLOW_GETNEXTNODEINFONULL_EXCEPTION.value);
        }
        Iterator iterator = nextNodeUserInfo.iterator();
        while (iterator.hasNext() && !(checkFlag = ((Boolean)BizCommonUtils.bizCommonUtils.workflowCoreClient.isFirstNode((nextNodeInfoDto = (NextNodeInfoDto)iterator.next()).getNextNodeId()).getData()).booleanValue())) {
        }
        return checkFlag;
    }

    public static boolean checkSubmitNodeIsFirst(ResultInstanceDto resultInstanceDto) {
        return (Boolean)BizCommonUtils.bizCommonUtils.workflowCoreClient.isFirstNode(resultInstanceDto.getNodeId()).getData();
    }

    @PostConstruct
    public void init() {
        bizCommonUtils = this;
        BizCommonUtils.bizCommonUtils.workflowCoreClient = this.workflowCoreClient;
        BizCommonUtils.bizCommonUtils.amqpTemplate = this.amqpTemplate;
    }

    public void getExceptionMessageAndSendExptionMQ(Exception e, ResultInstanceDto instanceInfo) throws JsonProcessingException {
        WFException exception = new WFException();
        exception.setPkId(StringUtils.uuid((boolean)true));
        exception.setBizId(instanceInfo.getBizId());
        exception.setBizType(instanceInfo.getBizType());
        exception.setFlowName(instanceInfo.getFlowName());
        exception.setInstanceId(instanceInfo.getInstanceId());
        exception.setNodeId(instanceInfo.getNodeId());
        exception.setNodeName(instanceInfo.getNodeName());
        exception.setUserId(instanceInfo.getCurrentUserId());
        exception.setOpType(instanceInfo.getCurrentOpType());
        exception.setFlowId(Long.valueOf(Long.parseLong(instanceInfo.getFlowId())));
        exception.setBizParam(ObjectMapperUtils.instance().writeValueAsString((Object)instanceInfo));
        exception.setExceptionInfo("\u9519\u8bef\u7c7b\u578b\uff1a" + e.getClass().getSimpleName() + "\r\n\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage() + "\r\n\u9519\u8bef\u4f4d\u7f6e\uff1a" + ObjectMapperUtils.instance().writeValueAsString((Object)e.getStackTrace()[0]));
        exception.setExceptionTime(DateUtils.getCurrDateTimeStr());
        BizCommonUtils.bizCommonUtils.amqpTemplate.convertAndSend("yusp-flow.exception", (Object)exception);
    }
}

