/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.util;

import cn.com.yusys.yusp.dto.client.http.ypxt.callguar.CallGuarReqDto;
import cn.com.yusys.yusp.enums.online.DscmsBizDbEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisBizGuarUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmisBizGuarUtils.class);
    private static String fixParameter = "|URLUSER|BB2C3CB8A662BFA3D3EB7335F99F59B1";

    public static void main(String[] args) {
        try {
            CallGuarReqDto callGuarReqDto = new CallGuarReqDto();
            callGuarReqDto.setPrefixUrl("http://10.85.10.31:7001/cms/callPage.do");
            callGuarReqDto.setCallMethod(DscmsBizDbEnum.CALLMETHOD_TGUAREXISTQRY.key);
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("Address", URLEncoder.encode(URLEncoder.encode("\u554a\u5b9e\u6253\u5b9e\u7684", "utf-8"), "utf-8"));
            parameter.put("Area", "100");
            parameter.put("BorrowNo", "1");
            parameter.put("BusNo", "1");
            parameter.put("CustNo", "1");
            parameter.put("DataFlag", DscmsBizDbEnum.DATAFLAG_01.key);
            parameter.put("EvalAmt", "10000");
            parameter.put("EvalType", DscmsBizDbEnum.EVALTYPE_01.key);
            parameter.put("GenDate", "2021-04-15");
            parameter.put("GrtFlg", DscmsBizDbEnum.GRTFLG_1.key);
            parameter.put("GuarNo", "1");
            parameter.put("GuarWay", DscmsBizDbEnum.GUARWAY_BZ.key);
            parameter.put("OperOrg", "1");
            parameter.put("OperUser", "1");
            parameter.put("OutSys", "1");
            parameter.put("PageMark", DscmsBizDbEnum.PAGEMARK_03.key);
            parameter.put("Property", DscmsBizDbEnum.Property_010.key);
            parameter.put("SystemFlag", DscmsBizDbEnum.SYSTEMFLAG_01.key);
            parameter.put("SystemNo", DscmsBizDbEnum.SYSTEMNO_01.key);
            parameter.put("Usage", "");
            parameter.put("WarnType", "1");
            parameter.put("WarnTypeCode", "1");
            callGuarReqDto.setParameter(parameter);
            String callguar = CmisBizGuarUtils.callguar(callGuarReqDto);
            LOGGER.info("---URL\u4e3a--- {}", (Object)callguar);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String callguar(CallGuarReqDto callGuarReqDto) {
        String prefixUrl = callGuarReqDto.getPrefixUrl();
        String callMethod = callGuarReqDto.getCallMethod();
        Map parameter = callGuarReqDto.getParameter();
        String callGuarUrl = prefixUrl.concat(DscmsBizDbEnum.SYMBOL_QUESTION.key).concat(CmisBizGuarUtils.generateParameterUrl(callMethod, parameter));
        return callGuarUrl;
    }

    private static String generateParameterUrl(String callMethod, Map<String, Object> parameter) {
        String parameterUrl = "";
        String address = Optional.ofNullable((String)parameter.get("Address")).orElse("");
        String area = Optional.ofNullable((String)parameter.get("Area")).orElse("");
        String borrowNo = Optional.ofNullable((String)parameter.get("BorrowNo")).orElse("");
        String busNo = Optional.ofNullable((String)parameter.get("BusNo")).orElse("");
        String custNo = Optional.ofNullable((String)parameter.get("CustNo")).orElse("");
        String dataFlag = Optional.ofNullable((String)parameter.get("DataFlag")).orElse("");
        String evalAmt = Optional.ofNullable((String)parameter.get("EvalAmt")).orElse("");
        String evalType = Optional.ofNullable((String)parameter.get("EvalType")).orElse(DscmsBizDbEnum.EVALTYPE_03.key);
        String genDate = Optional.ofNullable((String)parameter.get("GenDate")).orElse("");
        String grtFlg = Optional.ofNullable((String)parameter.get("GrtFlg")).orElse("");
        String guarNo = Optional.ofNullable((String)parameter.get("GuarNo")).orElse("");
        String guarWay = Optional.ofNullable((String)parameter.get("GuarWay")).orElse("");
        String operOrg = Optional.ofNullable((String)parameter.get("OperOrg")).orElse("");
        String operUser = Optional.ofNullable((String)parameter.get("OperUser")).orElse("");
        String outSys = Optional.ofNullable((String)parameter.get("OutSys")).orElse("");
        String pageMark = Optional.ofNullable((String)parameter.get("PageMark")).orElse("");
        String property = Optional.ofNullable((String)parameter.get("Property")).orElse("");
        String systemFlag = Optional.ofNullable((String)parameter.get("SystemFlag")).orElse("");
        String systemNo = Optional.ofNullable((String)parameter.get("SystemNo")).orElse("");
        String usage = Optional.ofNullable((String)parameter.get("Usage")).orElse("");
        String warnType = Optional.ofNullable((String)parameter.get("WarnType")).orElse("");
        String warnTypeCode = Optional.ofNullable((String)parameter.get("WarnTypeCode")).orElse("");
        String symbolOr = DscmsBizDbEnum.SYMBOL_OR.key;
        parameterUrl = parameterUrl.concat("parameter").concat(DscmsBizDbEnum.SYMBOL_EQUAL.key);
        if (Objects.equals(callMethod, DscmsBizDbEnum.CALLMETHOD_TGUAREXISTQRY.key)) {
            parameterUrl = parameterUrl.concat(DscmsBizDbEnum.CALLMETHOD_TGUAREXISTQRY.key).concat(fixParameter).concat(symbolOr).concat(systemNo).concat(symbolOr).concat(operUser).concat(symbolOr).concat(operOrg).concat(symbolOr).concat(guarWay).concat(symbolOr).concat(busNo).concat(symbolOr).concat(grtFlg).concat(symbolOr).concat(usage).concat(symbolOr).concat(property).concat(symbolOr).concat(evalAmt).concat(symbolOr).concat(area).concat(symbolOr).concat(custNo).concat(symbolOr).concat(evalType).concat(symbolOr).concat(address).concat(symbolOr).concat(borrowNo);
        } else if (Objects.equals(callMethod, DscmsBizDbEnum.CALLMETHOD_TGUARDETAILINFO.key)) {
            parameterUrl = parameterUrl.concat(DscmsBizDbEnum.CALLMETHOD_TGUARDETAILINFO.key).concat(fixParameter).concat(symbolOr).concat(systemNo).concat(symbolOr).concat(operUser).concat(symbolOr).concat(operOrg).concat(symbolOr).concat(guarNo).concat(symbolOr).concat(dataFlag).concat(symbolOr).concat(pageMark);
        } else if (Objects.equals(callMethod, DscmsBizDbEnum.CALLMETHOD_TGUARUPDATE.key)) {
            parameterUrl = parameterUrl.concat(DscmsBizDbEnum.CALLMETHOD_TGUARUPDATE.key).concat(fixParameter).concat(symbolOr).concat(systemNo).concat(symbolOr).concat(operUser).concat(symbolOr).concat(operOrg).concat(symbolOr).concat(guarNo).concat(symbolOr).concat(busNo).concat(symbolOr).concat(evalAmt).concat(symbolOr).concat(evalType).concat(symbolOr).concat(dataFlag).concat(symbolOr).concat(pageMark);
        } else if (Objects.equals(callMethod, DscmsBizDbEnum.CALLMETHOD_TGUARFIRSTEVAL.key)) {
            parameterUrl = parameterUrl.concat(DscmsBizDbEnum.CALLMETHOD_TGUARFIRSTEVAL.key).concat(fixParameter).concat(symbolOr).concat(systemFlag).concat(symbolOr).concat(operUser).concat(symbolOr).concat(operOrg).concat(symbolOr).concat(guarNo);
        } else if (Objects.equals(callMethod, DscmsBizDbEnum.CALLMETHOD_TGUARREEVALAPPLY.key)) {
            parameterUrl = parameterUrl.concat(DscmsBizDbEnum.CALLMETHOD_TGUARREEVALAPPLY.key).concat(fixParameter).concat(symbolOr).concat(systemFlag).concat(symbolOr).concat(operUser).concat(symbolOr).concat(operOrg).concat(symbolOr).concat(guarNo);
        } else if (Objects.equals(callMethod, DscmsBizDbEnum.CALLMETHOD_TCOLLWARNING.key)) {
            parameterUrl = parameterUrl.concat(DscmsBizDbEnum.CALLMETHOD_TCOLLWARNING.key).concat(fixParameter).concat(symbolOr).concat(systemFlag).concat(symbolOr).concat(operUser).concat(symbolOr).concat(operOrg).concat(symbolOr).concat(guarNo).concat(symbolOr).concat(warnType).concat(symbolOr).concat(warnTypeCode).concat(symbolOr).concat(genDate);
        } else if (Objects.equals(callMethod, DscmsBizDbEnum.CALLMETHOD_TWELCOME.key)) {
            parameterUrl = parameterUrl.concat(DscmsBizDbEnum.CALLMETHOD_TWELCOME.key).concat(fixParameter).concat(symbolOr).concat(systemNo).concat(symbolOr).concat(operUser).concat(symbolOr).concat(operOrg).concat(symbolOr).concat(outSys);
        }
        return parameterUrl;
    }
}

