/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisCommonUtils {
    private static Logger logger = LoggerFactory.getLogger(CmisCommonUtils.class);

    public static String getGenderByIDToFM(String id) {
        if (id.length() != 18 && id.length() != 15) {
            String message = "\u8eab\u4efd\u8bc1\u8f93\u5165\u6709\u8bef\uff01";
            return message;
        }
        if (id.length() == 18) {
            String value = id.substring(id.length() - 2, id.length() - 1);
            int gender = Integer.parseInt(value) % 2;
            return gender == 0 ? "F" : "M";
        }
        String value = id.substring(id.length() - 1, id.length());
        int gender = Integer.parseInt(value) % 2;
        return gender == 0 ? "F" : "M";
    }

    public static String getBirthdayByID(String id) {
        if (id.length() != 18) {
            String message = "\u8eab\u4efd\u8bc1\u8f93\u5165\u6709\u8bef\uff01";
            return message;
        }
        String birthday = id.substring(6, 14);
        return birthday;
    }

    public static String getAge(Date birthDate, String openDay) throws Exception {
        if (birthDate == null) {
            throw new Exception("\u51fa\u751f\u65e5\u671f\u4e0d\u80fd\u4e3anull");
        }
        int age = 0;
        Date now = new SimpleDateFormat("yyyyMMdd").parse(openDay);
        SimpleDateFormat formatY = new SimpleDateFormat("yyyy");
        SimpleDateFormat formatM = new SimpleDateFormat("MM");
        SimpleDateFormat formatD = new SimpleDateFormat("dd");
        String birthY = formatY.format(birthDate);
        String thisY = formatY.format(now);
        String birthM = formatM.format(birthDate);
        String thisM = formatM.format(now);
        String birthD = formatD.format(birthDate);
        String thisD = formatD.format(now);
        age = Integer.parseInt(thisY) - Integer.parseInt(birthY);
        if (birthM.compareTo(thisM) > 0) {
            --age;
        }
        if (thisM.compareTo(birthM) == 0 && birthD.compareTo(thisD) > 0) {
            --age;
        }
        if (age < 0) {
            age = 0;
        }
        return String.valueOf(age);
    }

    public static String getInstucde(String managerBrId) {
        if (managerBrId.startsWith("80")) {
            return "C1102137000013";
        }
        if (managerBrId.startsWith("81")) {
            return "C1100832000011";
        }
        return "C1115632000023";
    }

    public static int getBetweenMonth(String startDate, String endDate) throws Exception {
        double month;
        logger.info("\u8ba1\u7b97\u65e5\u671f\u76f8\u5dee\u6708\u4efd\u5f00\u59cb\uff1a\u8d77\u59cb\u65e5\u671f\u3010{}\u3011\u3001\u5230\u671f\u65e5\u671f\u3010{}\u3011", (Object)startDate, (Object)endDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar oldDate = Calendar.getInstance();
        Calendar newDate = Calendar.getInstance();
        oldDate.setTime(sdf.parse(startDate));
        newDate.setTime(sdf.parse(endDate));
        int year = oldDate.get(1) - newDate.get(1);
        if (year < 0) {
            year = -year;
            month = (double)(year * 12) - CmisCommonUtils.calMonthAndDay(oldDate, newDate);
        } else {
            month = (double)(year * 12) - CmisCommonUtils.calMonthAndDay(oldDate, newDate);
        }
        logger.info("\u8ba1\u7b97\u65e5\u671f\u76f8\u5dee\u6708\u4efd\u7ed3\u675f\uff1a\u8d77\u59cb\u65e5\u671f\u3010{}\u3011\u3001\u5230\u671f\u65e5\u671f\u3010{}\u3011\uff0c\u76f8\u5dee\u6708\u4efd\u3010{}\u3011", new Object[]{startDate, endDate, month});
        return (int)Math.ceil(month);
    }

    public static double calMonthAndDay(Calendar oldDate, Calendar newDate) {
        double month;
        if (oldDate.getActualMaximum(5) == oldDate.get(5) && newDate.getActualMaximum(5) == newDate.get(5)) {
            month = oldDate.get(2) - newDate.get(2);
        } else if (oldDate.get(5) == newDate.get(5)) {
            month = oldDate.get(2) - newDate.get(2);
        } else {
            double day = oldDate.get(5) - newDate.get(5);
            month = (double)(oldDate.get(2) - newDate.get(2)) + day / 31.0;
        }
        return month;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CmisCommonUtils.getBetweenMonth("2021-09-19", "2021-09-20"));
    }
}

