/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.context;

import cn.com.yusys.yusp.commons.autoconfigure.context.MessageSpecProperties;
import cn.com.yusys.yusp.commons.context.brave.ContextHolder;
import cn.com.yusys.yusp.commons.context.header.RequestContextInAdvice;
import cn.com.yusys.yusp.commons.context.header.ResponseContextOutAdvice;
import cn.com.yusys.yusp.commons.context.header.filter.RequestBodyClearFilter;
import cn.com.yusys.yusp.commons.context.header.process.MessageProcessor;
import cn.com.yusys.yusp.commons.context.header.resolver.MessageBodyMethodProcessor;
import cn.com.yusys.yusp.commons.context.header.resolver.MessageHeaderMethodProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ObjectToStringHttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Configuration
@ConditionalOnClass(value={MessageProcessor.class, ContextHolder.class})
@EnableConfigurationProperties(value={MessageSpecProperties.class})
public class HeaderSpecAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HeaderSpecAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public MessageProcessor contextServiceProcessor() {
        logger.debug("Init Default ServiceProcessor.");
        return new MessageProcessor.Default();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestContextInAdvice requestContextInAdvice(MessageProcessor processor) {
        logger.debug("Init Service Context in filter.");
        return new RequestContextInAdvice(processor);
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseContextOutAdvice responseContextOutAdvice(MessageProcessor processor) {
        logger.debug("Init Service Context out filter.");
        return new ResponseContextOutAdvice(processor);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageHeaderMethodProcessor messageHeaderMethodProcessor(MessageProcessor processor) {
        logger.debug("Init @MessageHeader method arguments processor.");
        return new MessageHeaderMethodProcessor(processor);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBodyMethodProcessor messageBodyMethodProcessor(MessageProcessor processor) {
        logger.debug("Init @MessageBody method arguments processor.");
        return new MessageBodyMethodProcessor(processor);
    }

    @Bean
    public RequestMappingHandlerAdapterPostProcessor requestMappingHandlerAdapterPostProcessor() {
        return new RequestMappingHandlerAdapterPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestBodyClearFilter requestBodyClearFilter() {
        return new RequestBodyClearFilter();
    }

    @Bean
    public FilterRegistrationBean<RequestBodyClearFilter> requestBodyClearFilterBean(RequestBodyClearFilter clearFilter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)clearFilter, new ServletRegistrationBean[0]);
        registrationBean.setName("request body filter");
        registrationBean.setOrder(10);
        return registrationBean;
    }

    static class RequestMappingHandlerAdapterPostProcessor
    implements SmartInitializingSingleton,
    ApplicationContextAware {
        private final List<Object> requestResponseBodyAdvice = new ArrayList<Object>();
        private final List<HttpMessageConverter<?>> converters = new ArrayList();
        private ApplicationContext context;

        RequestMappingHandlerAdapterPostProcessor() {
        }

        public void afterSingletonsInstantiated() {
            RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)this.context.getBean(RequestMappingHandlerAdapter.class);
            MessageHeaderMethodProcessor messageHeaderMethodProcessor = (MessageHeaderMethodProcessor)this.context.getBean(MessageHeaderMethodProcessor.class);
            MessageBodyMethodProcessor messageBodyMethodProcessor = (MessageBodyMethodProcessor)this.context.getBean(MessageBodyMethodProcessor.class);
            ArrayList<Object> argumentResolvers = new ArrayList<Object>(adapter.getArgumentResolvers());
            argumentResolvers.add(0, messageBodyMethodProcessor);
            argumentResolvers.add(1, messageHeaderMethodProcessor);
            adapter.setArgumentResolvers(argumentResolvers);
            this.initAdvice();
            this.initMessageConverters();
            RequestResponseBodyMethodProcessor requestResponseBodyMethodProcessor = new RequestResponseBodyMethodProcessor(this.converters, this.requestResponseBodyAdvice);
            messageHeaderMethodProcessor.setRequestResponseBodyMethodProcessor((HandlerMethodArgumentResolver)requestResponseBodyMethodProcessor);
            messageBodyMethodProcessor.setRequestResponseBodyMethodProcessor((HandlerMethodArgumentResolver)requestResponseBodyMethodProcessor);
        }

        private void initMessageConverters() {
            this.context.getBeansOfType(HttpMessageConverter.class).values().forEach(this.converters::add);
            ConversionService conversionService = (ConversionService)this.context.getBean("mvcConversionService", ConversionService.class);
            ObjectToStringHttpMessageConverter converter = new ObjectToStringHttpMessageConverter(conversionService);
            this.converters.add((HttpMessageConverter<?>)converter);
        }

        void initAdvice() {
            List adviceBeans = ControllerAdviceBean.findAnnotatedBeans((ApplicationContext)this.context);
            ArrayList<ControllerAdviceBean> requestResponseBodyAdviceBeans = new ArrayList<ControllerAdviceBean>();
            for (ControllerAdviceBean adviceBean : adviceBeans) {
                Class beanType = adviceBean.getBeanType();
                if (beanType == null) {
                    throw new IllegalStateException("Unresolvable type for ControllerAdviceBean:" + adviceBean);
                }
                if (!RequestBodyAdvice.class.isAssignableFrom(beanType) && !ResponseBodyAdvice.class.isAssignableFrom(beanType)) continue;
                requestResponseBodyAdviceBeans.add(adviceBean);
            }
            if (!requestResponseBodyAdviceBeans.isEmpty()) {
                this.requestResponseBodyAdvice.addAll(0, requestResponseBodyAdviceBeans);
            }
        }

        public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
            this.context = applicationContext;
        }
    }
}

