/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.framework;

import cn.com.yusys.yusp.commons.autoconfigure.framework.FrameworkProperties;
import cn.com.yusys.yusp.commons.module.standard.Dict;
import cn.com.yusys.yusp.commons.module.standard.Dicts;
import cn.com.yusys.yusp.commons.module.standard.FactoryDict;
import cn.com.yusys.yusp.commons.module.standard.StandardField;
import cn.com.yusys.yusp.commons.module.standard.StandardFields;
import cn.com.yusys.yusp.commons.module.standard.impl.ConfigurationFactoryDict;
import cn.com.yusys.yusp.commons.module.standard.impl.EnumClassFactoryDict;
import cn.com.yusys.yusp.commons.module.standard.impl.EnumClassFactoryStandardField;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Dict.class, StandardField.class})
@EnableConfigurationProperties(value={FrameworkProperties.class})
public class FrameworkAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="yusp.framework", name={"dict.enabled"}, matchIfMissing=true)
    public FactoryDictRegistry factoryDictRegistry(FrameworkProperties properties, ObjectProvider<List<FactoryDict>> factoryDictProvider) {
        return new FactoryDictRegistry(properties.getDict(), factoryDictProvider);
    }

    @Bean
    @ConditionalOnProperty(prefix="yusp.framework", name={"standard-field.enabled"}, matchIfMissing=true)
    public StandardFieldBeanDefinitionRegistry standardFieldBeanDefinitionRegistry() {
        return new StandardFieldBeanDefinitionRegistry();
    }

    @Bean
    @ConditionalOnProperty(prefix="yusp.framework", name={"standard-field.enabled"}, matchIfMissing=true)
    public StandardFieldRegistry standardFieldRegistry(FrameworkProperties properties) {
        return new StandardFieldRegistry(properties.getStandardField());
    }

    static class StandardFieldRegistry
    implements ApplicationRunner,
    ResourceLoaderAware {
        ResourceLoader resourceLoader;
        FrameworkProperties.StandardField standardFieldProperties;

        public StandardFieldRegistry(FrameworkProperties.StandardField standardFieldProperties) {
            this.standardFieldProperties = standardFieldProperties;
        }

        public void run(ApplicationArguments args) {
            try {
                Map stringStandardFieldMap = SpringContextUtils.getBeansOfType(StandardField.class);
                if (CollectionUtils.nonEmpty((Map)stringStandardFieldMap)) {
                    StandardFields.register(stringStandardFieldMap.values());
                }
            }
            catch (BeanCreationException stringStandardFieldMap) {
                // empty catch block
            }
            if (CollectionUtils.nonEmpty(this.standardFieldProperties.getEnumPackages())) {
                EnumClassFactoryStandardField enumClassFactoryStandardField = new EnumClassFactoryStandardField(this.resourceLoader, this.standardFieldProperties.getEnumPackages());
                StandardFields.register((Collection)enumClassFactoryStandardField.getObjects());
            }
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }
    }

    static class StandardFieldBeanDefinitionRegistry
    implements BeanDefinitionRegistryPostProcessor,
    ResourceLoaderAware,
    EnvironmentAware {
        ResourceLoader resourceLoader;
        Environment environment;

        StandardFieldBeanDefinitionRegistry() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            Binder binder = Binder.get((Environment)this.environment);
            BindResult bindResult = binder.bind("yusp.framework", FrameworkProperties.class);
            FrameworkProperties properties = (FrameworkProperties)bindResult.orElseGet(FrameworkProperties::new);
            if (CollectionUtils.nonEmpty(properties.getStandardField().getBeanPackages())) {
                ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
                scanner.setResourceLoader(this.resourceLoader);
                scanner.setEnvironment(this.environment);
                scanner.addIncludeFilter((metadataReader, metadataReaderFactory) -> {
                    if (metadataReader.getClassMetadata().isConcrete() && !metadataReader.getClassMetadata().getClassName().endsWith("package-info")) {
                        Class classType = ReflectionUtils.forName((String)metadataReader.getClassMetadata().getClassName());
                        return Objects.nonNull(classType) && !classType.isEnum() && StandardField.class.isAssignableFrom(classType);
                    }
                    return false;
                });
                scanner.scan(StringUtils.toStringArray(properties.getStandardField().getBeanPackages()));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }
    }

    static class FactoryDictRegistry
    implements ApplicationRunner,
    ResourceLoaderAware {
        FrameworkProperties.Dict dictProperties;
        ObjectProvider<List<FactoryDict>> factoryDictProvider;
        ResourceLoader resourceLoader;

        public FactoryDictRegistry(FrameworkProperties.Dict properties, ObjectProvider<List<FactoryDict>> factoryDictProvider) {
            this.dictProperties = properties;
            this.factoryDictProvider = factoryDictProvider;
        }

        public void run(ApplicationArguments args) {
            LinkedList<Object> factoryDictList = new LinkedList<Object>((Collection)this.factoryDictProvider.getIfAvailable(LinkedList::new));
            factoryDictList.add(new ConfigurationFactoryDict(this.dictProperties.getConfigPath(), this.dictProperties.getCharset()));
            if (CollectionUtils.nonEmpty(this.dictProperties.getEnumPackages())) {
                factoryDictList.add(new EnumClassFactoryDict(this.resourceLoader, this.dictProperties.getEnumPackages()));
            }
            Dicts.registerFactoryDict(factoryDictList);
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }
    }
}

