/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis;

import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import cn.com.yusys.yusp.commons.scan.BasePackage;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public abstract class MapperScanBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MapperScanBeanDefinitionRegistryPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    protected void mapperScanBeanDefinitionRegistry(BeanDefinitionRegistry registry, Consumer<List<String>> mapperScanPackages) {
        if (registry instanceof DefaultListableBeanFactory && Objects.nonNull(mapperScanPackages)) {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)registry;
            List<String> packages = null;
            try {
                String[] beanNames = beanFactory.getBeanNamesForType(MapperScanBasePackage.class);
                packages = Arrays.stream(beanNames).map(beanName -> (MapperScanBasePackage)beanFactory.getBean(beanName)).map(BasePackage::basePackage).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
            catch (Exception var6) {
                logger.warn("Please config mybatis mapper scan path or add @MapperScan annotation!");
            }
            if (CollectionUtils.isEmpty(packages)) {
                logger.warn("Not Config default scan package!");
                return;
            }
            if (logger.isDebugEnabled()) {
                packages.forEach(pkg -> logger.debug("Using auto-configuration base package '{}'", pkg));
                logger.debug("Searching for mappers annotated with @Mapper");
            }
            mapperScanPackages.accept(packages);
        }
    }
}

