/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.MybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus.MybatisPlusProperties;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus.MybatisPlusPropertiesCustomizer;
import cn.com.yusys.yusp.commons.mybatis.ConfigurationCustomizer;
import cn.com.yusys.yusp.commons.mybatis.config.SpringBootVFS;
import cn.com.yusys.yusp.commons.mybatisplus.extension.SqlSessionTemplateExtension;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, MybatisSqlSessionFactoryBean.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MybatisAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisPlusProperties.class})
public class MybatisPlusAutoConfiguration
implements InitializingBean {
    private MybatisPlusProperties properties;
    private Interceptor[] interceptors;
    private LanguageDriver[] languageDrivers;
    private ResourceLoader resourceLoader;
    private DatabaseIdProvider databaseIdProvider;
    private List<ConfigurationCustomizer> configurationCustomizers;
    private List<MybatisPlusPropertiesCustomizer> mybatisPlusPropertiesCustomizers;
    private ApplicationContext applicationContext;

    public MybatisPlusAutoConfiguration(MybatisPlusProperties properties, ObjectProvider<Interceptor[]> interceptorsProvider, ObjectProvider<LanguageDriver[]> languageDriversProvider, ResourceLoader resourceLoader, ObjectProvider<DatabaseIdProvider> databaseIdProvider, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider, ObjectProvider<List<MybatisPlusPropertiesCustomizer>> mybatisPlusPropertiesCustomizerProvider, ApplicationContext applicationContext) {
        this.properties = properties;
        Object[] interceptors = (Interceptor[])interceptorsProvider.getIfAvailable();
        if (CollectionUtils.nonEmpty((Object[])interceptors)) {
            AnnotationAwareOrderComparator.sort((Object[])interceptors);
        }
        this.interceptors = interceptors;
        this.languageDrivers = (LanguageDriver[])languageDriversProvider.getIfAvailable();
        this.resourceLoader = resourceLoader;
        this.databaseIdProvider = (DatabaseIdProvider)databaseIdProvider.getIfAvailable();
        List configurationCustomizers = (List)configurationCustomizersProvider.getIfAvailable();
        if (CollectionUtils.nonEmpty((Collection)configurationCustomizers)) {
            AnnotationAwareOrderComparator.sort((List)configurationCustomizers);
        }
        this.configurationCustomizers = configurationCustomizers;
        List mybatisPlusPropertiesCustomizers = (List)mybatisPlusPropertiesCustomizerProvider.getIfAvailable();
        if (CollectionUtils.nonEmpty((Collection)mybatisPlusPropertiesCustomizers)) {
            AnnotationAwareOrderComparator.sort((List)mybatisPlusPropertiesCustomizers);
        }
        this.mybatisPlusPropertiesCustomizers = mybatisPlusPropertiesCustomizers;
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        if (CollectionUtils.nonEmpty(this.mybatisPlusPropertiesCustomizers)) {
            this.mybatisPlusPropertiesCustomizers.forEach(i -> i.customize(this.properties));
        }
        this.checkConfigFileExists();
    }

    private void checkConfigFileExists() {
        if (this.properties.isCheckConfigLocation() && StringUtils.hasText((String)this.properties.getConfigLocation())) {
            Resource resource = this.resourceLoader.getResource(this.properties.getConfigLocation());
            Assert.state((boolean)resource.exists(), (String)("Cannot find config location: " + resource + " (please add config file or check your Mybatis configuration)"));
        }
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        Object[] mapperLocations;
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        factory.setVfs(SpringBootVFS.class);
        if (StringUtils.hasText((String)this.properties.getConfigLocation())) {
            factory.setConfigLocation(this.resourceLoader.getResource(this.properties.getConfigLocation()));
        }
        this.applyConfiguration(factory);
        if (this.properties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(this.properties.getConfigurationProperties());
        }
        if (!ObjectUtils.isEmpty((Object[])this.interceptors)) {
            factory.setPlugins(this.interceptors);
        }
        if (this.databaseIdProvider != null) {
            factory.setDatabaseIdProvider(this.databaseIdProvider);
        }
        if (StringUtils.hasLength((String)this.properties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
        }
        if (this.properties.getTypeAliasesSuperType() != null) {
            factory.setTypeAliasesSuperType(this.properties.getTypeAliasesSuperType());
        }
        if (StringUtils.hasLength((String)this.properties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(this.properties.getTypeHandlersPackage());
        }
        if (!ObjectUtils.isEmpty((Object[])(mapperLocations = this.properties.resolveMapperLocations()))) {
            factory.setMapperLocations((Resource[])mapperLocations);
        }
        this.getBeanThen(TransactionFactory.class, arg_0 -> ((MybatisSqlSessionFactoryBean)factory).setTransactionFactory(arg_0));
        Class<? extends LanguageDriver> defaultLanguageDriver = this.properties.getDefaultScriptingLanguageDriver();
        if (!ObjectUtils.isEmpty((Object[])this.languageDrivers)) {
            factory.setScriptingLanguageDrivers(this.languageDrivers);
        }
        Optional.ofNullable(defaultLanguageDriver).ifPresent(arg_0 -> ((MybatisSqlSessionFactoryBean)factory).setDefaultScriptingLanguageDriver(arg_0));
        if (StringUtils.hasLength((String)this.properties.getTypeEnumsPackage())) {
            factory.setTypeEnumsPackage(this.properties.getTypeEnumsPackage());
        }
        GlobalConfig globalConfig = this.properties.getGlobalConfig();
        this.getBeanThen(MetaObjectHandler.class, arg_0 -> ((GlobalConfig)globalConfig).setMetaObjectHandler(arg_0));
        this.getBeanThen(IKeyGenerator.class, i -> globalConfig.getDbConfig().setKeyGenerator(i));
        this.getBeanThen(ISqlInjector.class, arg_0 -> ((GlobalConfig)globalConfig).setSqlInjector(arg_0));
        this.getBeanThen(IdentifierGenerator.class, arg_0 -> ((GlobalConfig)globalConfig).setIdentifierGenerator(arg_0));
        factory.setGlobalConfig(globalConfig);
        return factory.getObject();
    }

    private <T> void getBeanThen(Class<T> clazz, Consumer<T> consumer) {
        if (this.applicationContext.getBeanNamesForType(clazz, false, false).length > 0) {
            consumer.accept(this.applicationContext.getBean(clazz));
        }
    }

    private void applyConfiguration(MybatisSqlSessionFactoryBean factory) {
        MybatisConfiguration configuration = this.properties.getConfiguration();
        if (configuration == null && !StringUtils.hasText((String)this.properties.getConfigLocation())) {
            configuration = new MybatisConfiguration();
        }
        if (configuration != null && CollectionUtils.nonEmpty(this.configurationCustomizers)) {
            for (ConfigurationCustomizer customizer : this.configurationCustomizers) {
                customizer.customize((Configuration)configuration);
            }
        }
        factory.setConfiguration(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        ExecutorType executorType = this.properties.getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplateExtension(sqlSessionFactory, executorType, this.properties.getBatchConfig().getFlushSize());
        }
        return new SqlSessionTemplateExtension(sqlSessionFactory, this.properties.getBatchConfig().getFlushSize());
    }
}

