/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.MybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus.MybatisPlusAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus.MybatisPlusProperties;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus.MybatisPlusPropertiesCustomizer;
import cn.com.yusys.yusp.commons.mybatis.ConfigurationCustomizer;
import cn.com.yusys.yusp.commons.mybatis.key.Sequence;
import cn.com.yusys.yusp.commons.mybatisplus.extension.DefaultEnumTypeHandler;
import cn.com.yusys.yusp.commons.mybatisplus.extension.EnumTypeHandler;
import cn.com.yusys.yusp.commons.mybatisplus.injector.DefaultSqlInjectorExtension;
import cn.com.yusys.yusp.commons.mybatisplus.injector.DynamicSqlInjectorExtension;
import cn.com.yusys.yusp.commons.mybatisplus.injector.ICustomSqlInjector;
import cn.com.yusys.yusp.commons.mybatisplus.sequence.SequenceIdentifierGenerator;
import cn.com.yusys.yusp.commons.mybatisplus.type.DateTypeHandler;
import cn.com.yusys.yusp.commons.mybatisplus.type.LocalDateTimeTypeHandler;
import cn.com.yusys.yusp.commons.mybatisplus.type.LocalDateTypeHandler;
import cn.com.yusys.yusp.commons.mybatisplus.type.SqlDateTypeHandler;
import cn.com.yusys.yusp.commons.mybatisplus.xmltags.MybatisPlusLanguageDriver;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.MybatisMapWrapperFactory;
import com.baomidou.mybatisplus.extension.incrementer.OracleKeyGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureAfter(value={MybatisAutoConfiguration.class, MybatisAutoConfiguration.SequenceAdapterConfiguration.class})
@AutoConfigureBefore(value={MybatisPlusAutoConfiguration.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, MybatisSqlSessionFactoryBean.class})
@EnableConfigurationProperties(value={MybatisPlusProperties.class})
public class MybatisPlusBeforeAutoConfiguration {
    @Bean
    @Order(value=-1)
    @ConditionalOnMissingClass(value={"com.github.pagehelper.PageInterceptor"})
    public InnerInterceptor paginationInnerInterceptor(MybatisPlusProperties properties) {
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        paginationInnerInterceptor.setMaxLimit(properties.getPage().getMaxLimit());
        paginationInnerInterceptor.setOverflow(properties.getPage().isOverflow());
        return paginationInnerInterceptor;
    }

    @Bean
    @Order(value=-2)
    public InnerInterceptor optimisticLockerInnerInterceptor() {
        return new OptimisticLockerInnerInterceptor();
    }

    @Bean
    @Order(value=0)
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<List<InnerInterceptor>> innerInterceptorProvider) {
        List innerInterceptors = (List)innerInterceptorProvider.getIfAvailable();
        if (CollectionUtils.nonEmpty((Collection)innerInterceptors)) {
            AnnotationAwareOrderComparator.sort((List)innerInterceptors);
        }
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.setInterceptors(innerInterceptors);
        return interceptor;
    }

    @Bean
    @Order(value=-11)
    public ConfigurationCustomizer mybatisMapWrapperFactoryCustomizer() {
        return configuration -> configuration.setObjectWrapperFactory((ObjectWrapperFactory)new MybatisMapWrapperFactory());
    }

    @Bean
    @ConditionalOnMissingBean
    public EnumTypeHandler<Enum<?>> defaultEnumTypeHandler() {
        return new EnumTypeHandler.Default();
    }

    @Bean
    @Order(value=-2147483648)
    public ConfigurationCustomizer mpXmlLanguageDriverPropertiesSet() {
        return configuration -> configuration.setDefaultScriptingLanguage(MybatisPlusLanguageDriver.class);
    }

    @Bean
    @Order(value=0)
    public MybatisPlusPropertiesCustomizer extensionCustomizer(ObjectProvider<List<ICustomSqlInjector>> customSqlInjectors, ObjectProvider<Sequence> sequence, ObjectProvider<BaseTypeHandler[]> handlersProvider) {
        return properties -> {
            if (properties.isFillDynamicSql()) {
                properties.getGlobalConfig().setSqlInjector((ISqlInjector)new DynamicSqlInjectorExtension((List)customSqlInjectors.getIfAvailable()));
            } else {
                properties.getGlobalConfig().setSqlInjector((ISqlInjector)new DefaultSqlInjectorExtension((List)customSqlInjectors.getIfAvailable()));
            }
            properties.getGlobalConfig().getDbConfig().setKeyGenerator((IKeyGenerator)new OracleKeyGenerator());
            properties.getGlobalConfig().setBanner(false);
            if (properties.getConfigLocation() == null && properties.getConfiguration() == null) {
                properties.setConfiguration(new MybatisConfiguration());
            }
            properties.getConfiguration().setDefaultEnumTypeHandler(DefaultEnumTypeHandler.class);
            Object[] handlers = (BaseTypeHandler[])handlersProvider.getIfAvailable();
            if (CollectionUtils.nonNull((Object)handlers)) {
                AnnotationAwareOrderComparator.sort((Object[])handlers);
                Arrays.stream(handlers).forEach(handler -> properties.getConfiguration().getTypeHandlerRegistry().register((TypeHandler)handler));
            }
            properties.getGlobalConfig().setIdentifierGenerator((IdentifierGenerator)new SequenceIdentifierGenerator((Sequence)sequence.getIfAvailable()));
            MybatisPlusProperties.DateTypeHandler typeHandler = properties.getDateTypeHandler();
            if (typeHandler.isEnabled()) {
                Asserts.nonEmpty((CharSequence)typeHandler.getDateFormatter(), (String[])new String[]{"Must config date formatter!"});
                Asserts.nonEmpty((CharSequence)typeHandler.getDateTimeFormatter(), (String[])new String[]{"Must config date formatter!"});
                Asserts.nonEmpty((CharSequence)typeHandler.getTimeZone(), (String[])new String[]{"Must config time zone!"});
                properties.getConfiguration().getTypeHandlerRegistry().register((TypeHandler)new DateTypeHandler(typeHandler.getDateTimeFormatter(), typeHandler.getTimeZone()));
                properties.getConfiguration().getTypeHandlerRegistry().register((TypeHandler)new SqlDateTypeHandler(typeHandler.getDateFormatter(), typeHandler.getTimeZone()));
                properties.getConfiguration().getTypeHandlerRegistry().register((TypeHandler)new LocalDateTypeHandler(typeHandler.getDateFormatter(), typeHandler.getTimeZone()));
                properties.getConfiguration().getTypeHandlerRegistry().register((TypeHandler)new LocalDateTimeTypeHandler(typeHandler.getDateTimeFormatter(), typeHandler.getTimeZone()));
            }
        };
    }
}

