/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.MybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.PageHelperProperties;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.MapperMybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.MapperProperties;
import cn.com.yusys.yusp.commons.data.model.PageResult;
import cn.com.yusys.yusp.commons.mapper.executor.SqlExecutor;
import cn.com.yusys.yusp.commons.mapper.interceptor.ResultSetHandlerInterceptor;
import cn.com.yusys.yusp.commons.mapper.key.KeyGeneratorInterceptor;
import cn.com.yusys.yusp.commons.mapper.key.generator.KeyGenerator;
import cn.com.yusys.yusp.commons.mapper.key.generator.SequenceKeyGenerator;
import cn.com.yusys.yusp.commons.mapper.key.generator.UuidKeyGenerator;
import cn.com.yusys.yusp.commons.mapper.page.DefaultPageResultConverter;
import cn.com.yusys.yusp.commons.mapper.page.PageResultConverter;
import cn.com.yusys.yusp.commons.mapper.page.PageResultInterceptor;
import cn.com.yusys.yusp.commons.mybatis.ConfigurationCustomizer;
import cn.com.yusys.yusp.commons.mybatis.key.Sequence;
import cn.com.yusys.yusp.commons.util.BooleanUtils;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureBefore(value={MapperMybatisAutoConfiguration.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, SqlExecutor.class})
public class MapperInterceptorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MapperInterceptorAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="'true'.equals('${mybatis-mapper.configuration.map-underscore-to-camel-case:true}')")
    public ResultSetHandlerInterceptor resultSetHandlerInterceptor() {
        return new ResultSetHandlerInterceptor();
    }

    @Bean
    public ConfigurationCustomizer mapUnderscoreToCamelCase(Environment environment) {
        return configuration -> {
            configuration.setMapUnderscoreToCamelCase(BooleanUtils.toBoolean((String)environment.getProperty("mybatis-mapper.configuration.map-underscore-to-camel-case", "false")));
            configuration.setJdbcTypeForNull(JdbcType.NULL);
        };
    }

    @Configuration
    @ConditionalOnClass(value={SqlExecutor.class})
    @EnableConfigurationProperties(value={MapperProperties.class})
    @AutoConfigureBefore(value={MapperMybatisAutoConfiguration.class})
    @AutoConfigureAfter(value={MybatisAutoConfiguration.SequenceAdapterConfiguration.class})
    public class KeyAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public UuidKeyGenerator uuidKeyGenerator() {
            return new UuidKeyGenerator();
        }

        @Bean
        @ConditionalOnBean(value={Sequence.class})
        public SequenceKeyGenerator sequenceKeyGenerator(Sequence sequence) {
            return new SequenceKeyGenerator(sequence);
        }

        @Bean
        @ConditionalOnMissingBean
        @Order(value=-10)
        public KeyGeneratorInterceptor keyGeneratorInterceptor(MapperProperties properties, ObjectProvider<List<KeyGenerator>> generatorProvider) {
            List keyGeneratorList = (List)generatorProvider.getIfAvailable();
            if (keyGeneratorList != null && !keyGeneratorList.isEmpty()) {
                AnnotationAwareOrderComparator.sort((List)keyGeneratorList);
            }
            log.debug("load custom key generator interceptor");
            return new KeyGeneratorInterceptor(properties.getKeyType(), keyGeneratorList);
        }
    }

    @Configuration
    @ConditionalOnClass(value={PageResultConverter.class})
    @EnableConfigurationProperties(value={PageHelperProperties.class})
    public static class PageConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PageResultConverter<PageResult<?>> defaultPageConverter() {
            log.debug("load default pageResultConverter");
            return new DefaultPageResultConverter();
        }

        @Bean
        @ConditionalOnMissingBean
        @Order(value=20)
        public PageResultInterceptor pageResultInterceptor(PageResultConverter<?> converter) {
            log.debug("load page result interceptor");
            return new PageResultInterceptor(converter);
        }
    }
}

