/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.async;

import cn.com.yusys.yusp.commons.excelcsv.ExporterImporter;
import cn.com.yusys.yusp.commons.excelcsv.async.ExportAsyncTask;
import cn.com.yusys.yusp.commons.excelcsv.async.ExportContext;
import cn.com.yusys.yusp.commons.excelcsv.async.ImportAsyncTask;
import cn.com.yusys.yusp.commons.excelcsv.async.ImportContext;
import cn.com.yusys.yusp.commons.excelcsv.async.Transaction;
import cn.com.yusys.yusp.commons.excelcsv.handle.IProgress;
import cn.com.yusys.yusp.commons.excelcsv.model.ProgressDto;
import java.util.concurrent.ExecutorService;

public class AsyncPoolServiceExecutor {
    private final ExecutorService executor;
    private final int maxPages;
    private final int pageSize;
    private final int sheetMaxRow;
    private final String tempDir;
    private final IProgress progress;
    private final Transaction transaction;

    public AsyncPoolServiceExecutor(ExecutorService executor, int maxPages, int pageSize, int sheetMaxRow, String tempDir, IProgress progress, Transaction transaction) {
        this.executor = executor;
        this.maxPages = maxPages;
        this.sheetMaxRow = sheetMaxRow;
        this.tempDir = tempDir;
        this.pageSize = pageSize;
        this.progress = progress;
        this.transaction = transaction;
    }

    public ProgressDto executeExport(ExportContext exportContext) {
        ExporterImporter exporterImporter = new ExporterImporter(this.sheetMaxRow, this.tempDir);
        exportContext.setProgress(this.progress);
        exportContext.setExporterImporter(exporterImporter);
        ExportAsyncTask task = new ExportAsyncTask(exportContext, this.maxPages, this.pageSize);
        this.executor.execute(task);
        return task.getProgressDto();
    }

    public ProgressDto executeImport(ImportContext importContext) {
        ExporterImporter exporterImporter = new ExporterImporter(this.sheetMaxRow, this.tempDir);
        importContext.setProgress(this.progress);
        importContext.setExporterImporter(exporterImporter);
        importContext.setTransaction(this.transaction);
        ImportAsyncTask task = new ImportAsyncTask(importContext);
        this.executor.execute(task);
        return task.getProgressDto();
    }
}

