/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.handle;

import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateConverter;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateTimeConverter;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.TimestampConverter;
import cn.com.yusys.yusp.commons.excelcsv.handle.ExcelCsvHead;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ColumnWidthProperty;
import com.alibaba.excel.metadata.property.DateTimeFormatProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.NumberFormatProperty;
import java.lang.reflect.Field;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class HeadProperty {
    private final Class<?> headClazz;
    private final List<ExcelCsvHead> excelCsvHeads;
    private final List<ExcelCsvHead> notIgnoreHeadInfos = new ArrayList<ExcelCsvHead>();
    private final Map<Integer, Head> headMap = new TreeMap<Integer, Head>();
    private final Map<Integer, ExcelContentProperty> contentPropertyMap = new TreeMap<Integer, ExcelContentProperty>();
    private final Map<String, ExcelContentProperty> fieldNameContentPropertyMap = new HashMap<String, ExcelContentProperty>(8);
    private final Map<String, Field> ignoreMap = new HashMap<String, Field>();
    private final List<List<String>> headNames = new ArrayList<List<String>>();

    public HeadProperty(Class<?> headClazz, List<ExcelCsvHead> excelCsvHeads) {
        Objects.requireNonNull(headClazz, "head class can not be null.");
        Objects.requireNonNull(excelCsvHeads, "head list class can not be null.");
        this.headClazz = headClazz;
        this.excelCsvHeads = excelCsvHeads;
        this.init();
    }

    private void init() {
        this.excelCsvHeads.forEach(excelCsvHead -> {
            Field field;
            try {
                field = ReflectionUtils.getDeclaredField(this.headClazz, (String)excelCsvHead.getFieldName());
            }
            catch (Exception e) {
                throw new IllegalStateException("can not find field " + excelCsvHead.getFieldName(), e);
            }
            Objects.requireNonNull(field, "can not find field " + excelCsvHead.getFieldName());
            if (excelCsvHead.getColumnIndex() >= 0) {
                this.notIgnoreHeadInfos.add((ExcelCsvHead)excelCsvHead);
                Head head = new Head(excelCsvHead.getColumnIndex(), excelCsvHead.getFieldName(), Collections.singletonList(excelCsvHead.getTitle()), Boolean.valueOf(true), Boolean.valueOf(true));
                head.setColumnWidthProperty(new ColumnWidthProperty(Integer.valueOf(excelCsvHead.getColumnWidth())));
                this.headMap.put(excelCsvHead.getColumnIndex(), head);
                this.headNames.add(head.getHeadNameList());
                ExcelContentProperty contentProperty = new ExcelContentProperty();
                contentProperty.setHead(head);
                contentProperty.setField(field);
                if (excelCsvHead.getFormatType() != null) {
                    if (excelCsvHead.getFormatType() == ExcelCsvHead.FormatType.DATE && Date.class == field.getType()) {
                        contentProperty.setDateTimeFormatProperty(new DateTimeFormatProperty(excelCsvHead.getFormat(), Boolean.valueOf(false)));
                    } else if (excelCsvHead.getFormatType() == ExcelCsvHead.FormatType.NUM) {
                        NumberFormatProperty formatProperty = new NumberFormatProperty(excelCsvHead.getFormat(), RoundingMode.HALF_UP);
                        contentProperty.setNumberFormatProperty(formatProperty);
                        contentProperty.setNumberFormatProperty(formatProperty);
                        CellDataTypeEnum cellType = excelCsvHead.getFormat().replaceAll("[#,.0]", "").length() > 0 ? CellDataTypeEnum.STRING : CellDataTypeEnum.NUMBER;
                        contentProperty.setConverter((Converter)DefaultConverterLoader.loadAllConverter().get(ConverterKeyBuild.buildKey(field.getType(), (CellDataTypeEnum)cellType)));
                    }
                }
                if (field.getType() == LocalDate.class) {
                    contentProperty.setConverter((Converter)new LocalDateConverter(excelCsvHead.getFormat()));
                } else if (field.getType() == LocalDateTime.class) {
                    contentProperty.setConverter((Converter)new LocalDateTimeConverter(excelCsvHead.getFormat()));
                } else if (field.getType() == Timestamp.class) {
                    contentProperty.setConverter((Converter)new TimestampConverter(excelCsvHead.getFormat()));
                }
                this.contentPropertyMap.put(excelCsvHead.getColumnIndex(), contentProperty);
                this.fieldNameContentPropertyMap.put(excelCsvHead.getFieldName(), contentProperty);
            } else {
                this.ignoreMap.put(excelCsvHead.getFieldName(), field);
            }
        });
    }

    public Class<?> getHeadClazz() {
        return this.headClazz;
    }

    public List<ExcelCsvHead> getExcelCsvHeads() {
        return this.excelCsvHeads;
    }

    public List<ExcelCsvHead> getNotIgnoreHeadInfos() {
        return this.notIgnoreHeadInfos;
    }

    public Map<Integer, Head> getHeadMap() {
        return this.headMap;
    }

    public Map<Integer, ExcelContentProperty> getContentPropertyMap() {
        return this.contentPropertyMap;
    }

    public Map<String, ExcelContentProperty> getFieldNameContentPropertyMap() {
        return this.fieldNameContentPropertyMap;
    }

    public Map<String, Field> getIgnoreMap() {
        return this.ignoreMap;
    }

    public List<List<String>> getHeadNames() {
        return this.headNames;
    }
}

