/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.handle.impl.adapter;

import cn.com.yusys.yusp.commons.excelcsv.handle.impl.adapter.RedisLookupCodeService;
import cn.com.yusys.yusp.commons.module.standard.Dict;
import cn.com.yusys.yusp.commons.module.standard.DictFactory;
import cn.com.yusys.yusp.commons.module.standard.impl.DictImpl;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class OcaLookupRedisAdapterDictFactory
implements DictFactory {
    private static final Logger logger = LoggerFactory.getLogger(OcaLookupRedisAdapterDictFactory.class);
    private final RedisLookupCodeService redisLookupCodeService;
    private final String version;
    private static final String ADAPTER_DICT_VERSION1 = "V1";
    private static final String ADAPTER_DICT_VERSION2 = "V2";
    private static final String ADAPTER_DICT_VERSION3 = "V3";

    public OcaLookupRedisAdapterDictFactory(RedisLookupCodeService redisLookupCodeService, String version) {
        this.redisLookupCodeService = redisLookupCodeService;
        this.version = version;
    }

    public Dict create(String dictCode) {
        if (ADAPTER_DICT_VERSION1.equals(this.version)) {
            return this.create(dictCode, this.getAdapterDictVersion1(dictCode));
        }
        if (ADAPTER_DICT_VERSION2.equals(this.version)) {
            return this.create(dictCode, this.getAdapterNewDictVersion(dictCode, this.redisLookupCodeService::version2));
        }
        if (ADAPTER_DICT_VERSION3.equals(this.version)) {
            return this.create(dictCode, this.getAdapterNewDictVersion(dictCode, this.redisLookupCodeService::version3));
        }
        return null;
    }

    private Dict create(String dictCode, Map<String, String> map) {
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        String locale = LocaleContextHolder.getLocale().toString();
        logger.info("Get lookup dict locale.Current locale is [{}]", (Object)locale);
        DictImpl dict = DictImpl.of((String)dictCode);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dict.addDictItem(locale, entry.getKey(), entry.getValue());
        }
        return dict;
    }

    private Map<String, String> getAdapterDictVersion1(String lookupCode) {
        List<Map<String, String>> itemMapList;
        HashMap<String, String> itemMap = null;
        Map<String, List<Map<String, String>>> resultMap = this.redisLookupCodeService.version1(lookupCode);
        if (null != resultMap && CollectionUtils.nonEmpty(itemMapList = resultMap.get(lookupCode))) {
            itemMap = new HashMap<String, String>(itemMapList.size());
            for (Map<String, String> map : itemMapList) {
                itemMap.put(map.get("key"), map.get("value"));
            }
        }
        return itemMap;
    }

    private Map<String, String> getAdapterNewDictVersion(String lookupCode, Function<String, List<Object>> function) {
        List<Object> resultList = function.apply(lookupCode);
        if (CollectionUtils.nonEmpty(resultList)) {
            HashMap<String, String> itemMap = new HashMap<String, String>(resultList.size());
            resultList.stream().filter(obj -> Map.class.isAssignableFrom(obj.getClass())).map(obj -> (Map)obj).forEach(map -> itemMap.put(StringUtils.replaceObjNull(map.get("key")), StringUtils.replaceObjNull(map.get("value"))));
            return itemMap;
        }
        return Collections.emptyMap();
    }
}

