/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.model;

import cn.com.yusys.yusp.commons.excelcsv.annotation.ExcelField;
import cn.com.yusys.yusp.commons.module.standard.StandardField;
import cn.com.yusys.yusp.commons.module.standard.StandardFields;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.i18n.LocaleContextHolder;

public class FieldInfo {
    private final Field field;
    private final String name;
    private final StandardField stdField;
    private final String dictCode;
    private final String title;
    private final int length;
    private int order;
    private int viewLength;
    private final String format;

    public FieldInfo(Field field) {
        this.field = Optional.of(field).orElseThrow(() -> new NullPointerException("the field is null."));
        this.name = field.getName();
        this.stdField = this.resolveStdField(field, null);
        if (this.stdField == null) {
            this.length = -1;
            this.dictCode = null;
        } else {
            this.length = this.stdField.length();
            this.dictCode = this.stdField.dictCode();
        }
        this.title = this.resolveTitle(field, this.stdField, null);
        this.order = 0;
        this.format = "";
    }

    public FieldInfo(Field field, ExcelField ef) {
        this.field = Optional.of(field).orElseThrow(() -> new NullPointerException("the field is null."));
        Objects.requireNonNull(ef, "Ef can not be null.");
        this.name = field.getName();
        this.stdField = this.resolveStdField(field, ef);
        if (this.stdField == null) {
            this.length = -1;
            this.dictCode = ef.dictCode();
        } else {
            this.length = this.stdField.length();
            this.dictCode = StringUtils.isEmpty((CharSequence)this.stdField.dictCode()) ? ef.dictCode() : this.stdField.dictCode();
        }
        this.title = this.resolveTitle(field, this.stdField, ef);
        this.viewLength = ef.viewLength();
        this.order = ef.order();
        this.format = ef.format();
    }

    private StandardField resolveStdField(Field field, ExcelField ef) {
        if (ef != null && !ef.stdField().isEmpty()) {
            return StandardFields.getField((String)ef.stdField());
        }
        if (field != null) {
            return StandardFields.getField((String)field.getName());
        }
        return null;
    }

    private String resolveTitle(Field field, StandardField stdField, ExcelField ef) {
        if (stdField != null) {
            return stdField.getName(LocaleContextHolder.getLocale());
        }
        if (ef != null && !ef.title().isEmpty()) {
            return ef.title();
        }
        if (field != null) {
            return field.getName();
        }
        return "";
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public StandardField getStdField() {
        return this.stdField;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getTitle() {
        return this.title;
    }

    public int getLength() {
        return this.length;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getViewLength() {
        if (this.viewLength <= 0) {
            this.viewLength = this.computeViewLength();
        }
        return this.viewLength;
    }

    public String getFormat() {
        return this.format;
    }

    private int computeViewLength() {
        if (this.title.length() * 2 < this.length) {
            return this.length;
        }
        int titleLength = this.title.chars().map(c -> c < 256 ? 1 : 2).sum();
        return Math.max(this.length, titleLength);
    }
}

