/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.template;

import cn.com.yusys.yusp.commons.redis.exception.YuspRedisException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class YuspRedisTemplate {
    private static final Logger logger = LoggerFactory.getLogger(YuspRedisTemplate.class);
    private RedisTemplate<String, Object> redisTemplate;

    public YuspRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Boolean expire(String key, long time) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
    }

    public long getExpire(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> this.redisTemplate.hasKey((Object)key));
    }

    public boolean del(String ... key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (key.length > 0) {
            if (key.length == 1) {
                return this.redisTemplate.delete((Object)key[0]);
            }
            Long delete = this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            if ((long)key.length == delete) {
                return true;
            }
            logger.warn("YuspRedisTemplate del success.Planned to delete {}, actually deleted {}", (Object)key.length, (Object)delete);
            return true;
        }
        return false;
    }

    public void casPut(String key, Object expectValue, Object newValue) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)expectValue, (String)"ExpectValue must not be null!");
        Assert.notNull((Object)newValue, (String)"NewValue must not be null!");
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText("local v1 = redis.call('get',KEYS[1])\nif (v1 == ARGV[2]) then \n    redis.call('set',KEYS[1],ARGV[1])\nend\n");
        redisScript.setResultType(String.class);
        this.redisTemplate.execute((RedisScript)redisScript, Collections.singletonList(key), new Object[]{newValue, expectValue});
    }

    public boolean setNx(String key, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"ExpectValue must not be null!");
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value);
    }

    public List<String> keys(String pattern) {
        ArrayList<String> keys = new ArrayList<String>();
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }

    private void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());){
                cursor.forEachRemaining(consumer);
                Object var5_6 = null;
                return var5_6;
            }
            catch (IOException e) {
                throw new YuspRedisException(e);
            }
        });
    }

    public boolean set(String key, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        });
    }

    public boolean set(String key, Object value, long time) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        });
    }

    public Object get(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean hset(String key, String item, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        });
    }

    public boolean hsetnx(String key, String item, String value) {
        return this.redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)item, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hsetxx(String key, String item, String value) {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText("local isExist = redis.call('HEXISTS', KEYS[1], KEYS[2])\nif isExist == 1\nthen\n  redis.call('HSET', KEYS[1], KEYS[2], ARGV[1])\nelse\n   isExist = 0\nend\nreturn isExist");
        redisScript.setResultType(Long.class);
        ArrayList<String> strList = new ArrayList<String>();
        strList.add(key);
        RedisConnectionFactory connectionFactory = this.redisTemplate.getConnectionFactory();
        try (RedisConnection connection = connectionFactory.getConnection();){
            Long result = null;
            byte[][] keysAndArgs = new byte[3][];
            RedisSerializer keySerializer = this.redisTemplate.getKeySerializer();
            RedisSerializer hashKeySerializer = this.redisTemplate.getHashKeySerializer();
            RedisSerializer hashValueSerializer = this.redisTemplate.getHashValueSerializer();
            keysAndArgs[0] = keySerializer.serialize((Object)key);
            keysAndArgs[1] = hashKeySerializer.serialize((Object)item);
            keysAndArgs[2] = hashValueSerializer.serialize((Object)value);
            try {
                result = (Long)connection.evalSha(redisScript.getSha1(), ReturnType.INTEGER, 1, (byte[][])keysAndArgs);
            }
            catch (Exception e) {
                result = (Long)connection.eval(this.redisTemplate.getStringSerializer().serialize((Object)redisScript.getScriptAsString()), ReturnType.INTEGER, 1, (byte[][])keysAndArgs);
            }
            Long l = result;
            return l;
        }
    }

    public boolean hHasKey(String key, String item) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)item, (String)"Item must not be null!");
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public Object hget(String key, String item) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)item, (String)"Item must not be null!");
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public void hdel(String key, Object ... item) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)item, (String)"Item must not be null!");
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        });
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        });
    }

    public Map<Object, Object> hmget(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public long sSet(String key, Object ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate sSet error.", (Throwable)e);
            return 0L;
        }
    }

    private boolean exe(ExeFunction exeFunction) {
        try {
            return exeFunction.exe();
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate error.", (Throwable)e);
            return false;
        }
    }

    public Set<Object> sGet(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate sGet error.", (Throwable)e);
            return null;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate sSetAndTime error.", (Throwable)e);
            return 0L;
        }
    }

    public long sSetGetSize(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate sGetSetSize error.", (Throwable)e);
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate setRemove error.", (Throwable)e);
            return 0L;
        }
    }

    public boolean lSet(String key, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        });
    }

    public List<Object> lGet(String key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate lGet error.", (Throwable)e);
            return null;
        }
    }

    public long lGetListSize(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate lGetListSize error.", (Throwable)e);
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate lGetIndex error.", (Throwable)e);
            return null;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        });
    }

    public boolean lSet(String key, List<Object> value, long time) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForList().rightPushAll((Object)key, (Collection)value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        });
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.exe(() -> {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        });
    }

    public long lRemove(String key, long count, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.redisTemplate.opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            logger.error("YuspRedisTemplate lRemove error.", (Throwable)e);
            return 0L;
        }
    }

    public Long incr(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.redisTemplate.opsForValue().increment((Object)key);
    }

    public Long incr(String key, String field) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, 1L);
    }

    public String blpop(String key, int timeout) {
        Object leftPop = this.redisTemplate.opsForList().leftPop((Object)key, (long)timeout, TimeUnit.SECONDS);
        if (leftPop != null) {
            return String.valueOf(leftPop);
        }
        return null;
    }

    public String lpop(String key) {
        Object leftPop = this.redisTemplate.opsForList().leftPop((Object)key);
        if (leftPop != null) {
            return String.valueOf(leftPop);
        }
        return null;
    }

    public String brpop(String key, int timeout) {
        Object leftPop = this.redisTemplate.opsForList().rightPop((Object)key, (long)timeout, TimeUnit.SECONDS);
        if (leftPop != null) {
            return String.valueOf(leftPop);
        }
        return null;
    }

    public String rpop(String key) {
        Object leftPop = this.redisTemplate.opsForList().rightPop((Object)key);
        if (leftPop != null) {
            return String.valueOf(leftPop);
        }
        return null;
    }

    public void lpush(String key, String value) {
        this.redisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public void rpush(String key, String value) {
        this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    static interface ExeFunction {
        public boolean exe() throws Exception;
    }
}

