/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisHelper {
    private static final Logger logger = LoggerFactory.getLogger(RedisHelper.class);
    private StringRedisTemplate stringRedisTemplate;

    public RedisHelper(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void scan(String pattern, Consumer<byte[]> consumer) {
        this.stringRedisTemplate.execute(connection -> {
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());){
                cursor.forEachRemaining(consumer);
                Object var5_6 = null;
                return var5_6;
            }
            catch (IOException e) {
                logger.error("Redis Scan keys[{}] occured error,errorMsg:{} ", (Object)pattern, (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    public List<String> keys(String pattern) {
        ArrayList<String> keys = new ArrayList<String>();
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }
}

