/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.key;

import cn.com.yusys.yusp.commons.mapper.CommonMapper;
import cn.com.yusys.yusp.commons.mapper.exception.YuMapperException;
import cn.com.yusys.yusp.commons.mapper.key.annotation.Generated;
import cn.com.yusys.yusp.commons.mapper.key.annotation.RegisterKeyGenerator;
import cn.com.yusys.yusp.commons.mapper.key.generator.KeyGenerator;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class KeyGeneratorInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(KeyGeneratorInterceptor.class);
    private final Map<String, KeyGenerator> keyGeneratorMap = new ConcurrentHashMap<String, KeyGenerator>();
    private final String keyType;
    private static final Map<Class<?>, List<Field>> keys = new ConcurrentHashMap();

    public KeyGeneratorInterceptor(String keyType, List<KeyGenerator> keyGeneratorList) {
        this.keyType = keyType;
        if (keyGeneratorList != null && !keyGeneratorList.isEmpty()) {
            keyGeneratorList.forEach(this::registerKeyGenerator);
        }
    }

    private void registerKeyGenerator(KeyGenerator keyGenerator) {
        RegisterKeyGenerator registerKeyGenerator = (RegisterKeyGenerator)BeanUtils.findAnnotation(keyGenerator.getClass(), RegisterKeyGenerator.class);
        if (registerKeyGenerator == null || StringUtils.isEmpty((CharSequence)registerKeyGenerator.value())) {
            return;
        }
        this.keyGeneratorMap.put(registerKeyGenerator.value(), keyGenerator);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (ArrayUtils.nonEmpty((Object[])invocation.getArgs()) && invocation.getArgs().length > 1) {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Object target = invocation.getArgs()[1];
            if (Objects.nonNull(target)) {
                SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
                this.generateKeys(sqlCommandType, this.getEntityClassType(mappedStatement, target), target);
            } else {
                logger.warn("Mapper id:{}, parameter object is null, cannot generate primary key automatically!", (Object)mappedStatement.getId());
            }
        }
        return invocation.proceed();
    }

    protected void generateKeys(SqlCommandType sqlCommandType, Class<?> entityClass, Object target) {
        if (!SqlCommandType.INSERT.equals((Object)sqlCommandType)) {
            return;
        }
        if (Collection.class.isAssignableFrom(entityClass) || Map.class.isAssignableFrom(entityClass)) {
            logger.warn("Target class type unsupported:{} or {}", (Object)Collection.class.getSimpleName(), (Object)Map.class.getSimpleName());
            return;
        }
        List keyList = keys.computeIfAbsent(entityClass, classType -> {
            List allFields = ReflectionUtils.getFields((Class)classType);
            return Optional.ofNullable(allFields).map(fields -> fields.stream().filter(field -> BeanUtils.findAnnotation((Field)field, Generated.class) != null).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        });
        keyList.forEach(field -> this.generateKey(target, entityClass, (Field)field));
    }

    private Class<?> getEntityClassType(MappedStatement mappedStatement, Object target) {
        String id = mappedStatement.getId();
        String className = id.substring(0, id.lastIndexOf("."));
        Class<?> classType = ReflectionUtils.forName((String)className);
        if (Objects.nonNull(classType)) {
            return !classType.isInterface() ? classType : (CommonMapper.class.isAssignableFrom(classType) ? ReflectionUtils.forName((String)((ParameterizedTypeImpl)classType.getGenericInterfaces()[0]).getActualTypeArguments()[0].getTypeName()) : (List.class.isAssignableFrom(target.getClass()) ? ((List)target).get(0).getClass() : target.getClass()));
        }
        return null;
    }

    protected void generateKey(Object target, Class<?> entityClass, Field field) {
        Generated generated = (Generated)BeanUtils.findAnnotation((Field)field, Generated.class);
        if (generated == null) {
            return;
        }
        String type = generated.value();
        if (StringUtils.isEmpty((CharSequence)type) && StringUtils.isEmpty((CharSequence)(type = this.keyType))) {
            return;
        }
        KeyGenerator keyGenerator = this.keyGeneratorMap.get(type);
        if (keyGenerator == null) {
            throw new YuMapperException("type:{" + type + "} KeyGenerator not register");
        }
        keyGenerator.generate(target, entityClass, field);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

