/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.sql;

import cn.com.yusys.yusp.commons.mapper.exception.YuMapperException;
import cn.com.yusys.yusp.commons.mapper.sql.SqlHelper;
import cn.com.yusys.yusp.commons.mapper.sql.method.SqlMethod;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.Configuration;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

public abstract class AbstractSqlHelper
implements SqlHelper {
    private Config config;
    private Configuration configuration;

    public AbstractSqlHelper(Configuration configuration, Config config) {
        this.configuration = configuration;
        this.config = config;
    }

    @Override
    public void injectMethod(Class<?> entityClass, String method) throws YuMapperException {
        List<SqlMethod> methods = this.getMethodList();
        SqlMethod sqlMethod = this.match(method, methods);
        if (sqlMethod != null) {
            EntityHelper.initEntityNameMap(entityClass, (Config)this.config);
            MapperBuilderAssistant assistant = new MapperBuilderAssistant(this.configuration, "");
            assistant.setCurrentNamespace(entityClass.getName());
            sqlMethod.inject(assistant, EntityHelper.getEntityTable(entityClass), this.config);
        }
    }

    @Override
    public void initEntityTable(Class<?> entityClass) {
        EntityHelper.initEntityNameMap(entityClass, (Config)this.config);
    }

    protected SqlMethod match(String method, List<SqlMethod> methods) throws YuMapperException {
        if (methods != null && !methods.isEmpty()) {
            for (SqlMethod sqlMethod : methods) {
                if (sqlMethod == null || !StringUtils.equals((CharSequence)method, (CharSequence)sqlMethod.getName())) continue;
                return sqlMethod;
            }
        }
        throw new YuMapperException("UnSupport method:" + method);
    }

    protected abstract List<SqlMethod> getMethodList();
}

