/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.pool.ExceptionSorter;
import java.sql.SQLException;
import java.util.Properties;

public class MySqlExceptionSorter
implements ExceptionSorter {
    @Override
    public boolean isExceptionFatal(SQLException e) {
        String sqlState = e.getSQLState();
        int errorCode = e.getErrorCode();
        if (sqlState != null && sqlState.startsWith("08")) {
            return true;
        }
        switch (errorCode) {
            case 1004: 
            case 1005: 
            case 1015: 
            case 1021: 
            case 1037: 
            case 1038: 
            case 1040: 
            case 1041: 
            case 1042: 
            case 1043: 
            case 1045: 
            case 1047: 
            case 1081: 
            case 1129: 
            case 1130: {
                return true;
            }
        }
        if (errorCode >= -10000 && errorCode <= -9000) {
            return true;
        }
        String message = e.getMessage();
        if (message != null && message.length() > 0) {
            String errorText = message.toUpperCase();
            if (errorCode == 0 && errorText.contains("COMMUNICATIONS LINK FAILURE") || errorText.contains("COULD NOT CREATE CONNECTION") || errorText.contains("NO DATASOURCE") || errorText.contains("NO ALIVE DATASOURCE")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void configFromProperties(Properties properties) {
    }
}

