/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4;

import com.alibaba.qlexpress4.ClassSupplier;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultClassSupplier
implements ClassSupplier {
    private static final DefaultClassSupplier INSTANCE = new DefaultClassSupplier();
    private final Map<String, Optional<Class<?>>> cache = new ConcurrentHashMap();

    public static DefaultClassSupplier getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<?> loadCls(String clsQualifiedName) {
        Optional clsOp = this.cache.computeIfAbsent(clsQualifiedName, this::loadClsInner);
        return clsOp.orElse(null);
    }

    private Optional<Class<?>> loadClsInner(String clsQualifiedName) {
        try {
            Class<?> aClass = Class.forName(clsQualifiedName);
            return Optional.of(aClass);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return Optional.empty();
        }
    }
}

