/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.a4runtime.CharStreams;
import com.alibaba.qlexpress4.a4runtime.CommonTokenStream;
import com.alibaba.qlexpress4.a4runtime.Parser;
import com.alibaba.qlexpress4.a4runtime.Token;
import com.alibaba.qlexpress4.a4runtime.WritableToken;
import com.alibaba.qlexpress4.a4runtime.atn.DecisionInfo;
import com.alibaba.qlexpress4.a4runtime.atn.DecisionState;
import com.alibaba.qlexpress4.a4runtime.atn.ParserATNSimulator;
import com.alibaba.qlexpress4.a4runtime.atn.PredictionMode;
import com.alibaba.qlexpress4.aparser.AliasTokenStream;
import com.alibaba.qlexpress4.aparser.InterpolationMode;
import com.alibaba.qlexpress4.aparser.ParserOperatorManager;
import com.alibaba.qlexpress4.aparser.QLErrorListener;
import com.alibaba.qlexpress4.aparser.QLErrorStrategy;
import com.alibaba.qlexpress4.aparser.QLExtendLexer;
import com.alibaba.qlexpress4.aparser.QLExtendParser;
import com.alibaba.qlexpress4.aparser.QLParser;
import com.alibaba.qlexpress4.runtime.operator.OperatorManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SyntaxTreeFactory {
    private static final AtomicBoolean IS_WARM_UP = new AtomicBoolean();

    public static void warmUp() {
        if (IS_WARM_UP.compareAndSet(false, true)) {
            SyntaxTreeFactory.warmUpExpress("1+1");
            SyntaxTreeFactory.warmUpExpress("a = b + c");
        }
    }

    private static void warmUpExpress(String script) {
        SyntaxTreeFactory.buildTree(script, new OperatorManager(), false, false, s -> {}, InterpolationMode.SCRIPT, "${", "}");
    }

    public static QLParser.ProgramContext buildTree(String script, ParserOperatorManager operatorManager, boolean printTree, boolean profile, Consumer<String> printer, InterpolationMode interpolationMode, String selectorStart, String selectorEnd) {
        QLExtendLexer lexer = new QLExtendLexer(CharStreams.fromString(script), script, interpolationMode, selectorStart, selectorEnd);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        QLExtendParser qlGrammarParser = new QLExtendParser(new AliasTokenStream(tokens, operatorManager), operatorManager, interpolationMode);
        if (!printTree) {
            qlGrammarParser.removeErrorListeners();
        }
        qlGrammarParser.addErrorListener(new QLErrorListener(script));
        qlGrammarParser.setErrorHandler(new QLErrorStrategy());
        ((ParserATNSimulator)qlGrammarParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        if (profile) {
            qlGrammarParser.setProfile(true);
        }
        QLParser.ProgramContext programContext = qlGrammarParser.program();
        if (printTree) {
            printer.accept(tokens.getTokens().stream().map(Token::getText).collect(Collectors.joining(" | ")));
            printer.accept(programContext.toStringTree(qlGrammarParser));
        }
        if (profile) {
            SyntaxTreeFactory.profileParser(qlGrammarParser);
        }
        return programContext;
    }

    private static void profileParser(Parser parser) {
        System.out.printf("%-35s", "rule");
        System.out.printf("%-15s", "time");
        System.out.printf("%-15s", "invocations");
        System.out.printf("%-15s", "lookahead");
        System.out.printf("%-15s", "lookahead(max)");
        System.out.printf("%-15s", "ambiguities");
        System.out.printf("%-15s", "errors");
        System.out.printf("%-15s", "fallBack");
        System.out.println();
        for (DecisionInfo decisionInfo : parser.getParseInfo().getDecisionInfo()) {
            DecisionState ds = parser.getATN().getDecisionState(decisionInfo.decision);
            String rule = parser.getRuleNames()[ds.ruleIndex];
            if (decisionInfo.timeInPrediction <= 0L) continue;
            System.out.printf("%-35s", rule);
            System.out.printf("%-15s", decisionInfo.timeInPrediction);
            System.out.printf("%-15s", decisionInfo.invocations);
            System.out.printf("%-15s", decisionInfo.SLL_TotalLook);
            System.out.printf("%-15s", decisionInfo.SLL_MaxLook);
            System.out.printf("%-15s", decisionInfo.ambiguities.size());
            System.out.printf("%-15s", decisionInfo.errors);
            System.out.printf("%-15s", decisionInfo.LL_Fallback);
            System.out.println();
        }
    }

    public static Token preHandleToken(Token originToken, ParserOperatorManager operatorManager) {
        Integer aliasId;
        if (originToken instanceof WritableToken && originToken.getType() == 91 && (aliasId = operatorManager.getAlias(originToken.getText())) != null && originToken.getType() != aliasId.intValue()) {
            ((WritableToken)originToken).setType(aliasId);
        }
        return originToken;
    }
}

