/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.aparser;

import com.alibaba.qlexpress4.a4runtime.Token;
import com.alibaba.qlexpress4.aparser.QLParser;
import com.alibaba.qlexpress4.aparser.QLParserBaseVisitor;
import com.alibaba.qlexpress4.runtime.trace.TracePointTree;
import com.alibaba.qlexpress4.runtime.trace.TraceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TraceExpressionVisitor
extends QLParserBaseVisitor<TracePointTree> {
    private final List<TracePointTree> expressionTracePoints = new ArrayList<TracePointTree>();

    public List<TracePointTree> getExpressionTracePoints() {
        return this.expressionTracePoints;
    }

    @Override
    public TracePointTree visitThrowStatement(QLParser.ThrowStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.STATEMENT, Collections.emptyList(), ctx.getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitLocalVariableDeclarationStatement(QLParser.LocalVariableDeclarationStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.STATEMENT, Collections.emptyList(), ctx.getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitExpressionStatement(QLParser.ExpressionStatementContext ctx) {
        TracePointTree expressionTrace = this.visitExpression(ctx.expression());
        this.expressionTracePoints.add(expressionTrace);
        return null;
    }

    @Override
    public TracePointTree visitWhileStatement(QLParser.WhileStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.STATEMENT, Collections.emptyList(), ctx.getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitTraditionalForStatement(QLParser.TraditionalForStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.STATEMENT, Collections.emptyList(), ctx.getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitForEachStatement(QLParser.ForEachStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.STATEMENT, Collections.emptyList(), ctx.getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitFunctionStatement(QLParser.FunctionStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.DEFINE_FUNCTION, Collections.emptyList(), ctx.varId().getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitMacroStatement(QLParser.MacroStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.DEFINE_MACRO, Collections.emptyList(), ctx.varId().getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitBreakContinueStatement(QLParser.BreakContinueStatementContext ctx) {
        TracePointTree tracePoint = this.newPoint(TraceType.STATEMENT, Collections.emptyList(), ctx.getStart());
        this.expressionTracePoints.add(tracePoint);
        return null;
    }

    @Override
    public TracePointTree visitReturnStatement(QLParser.ReturnStatementContext ctx) {
        QLParser.ExpressionContext returnExpressionContext = ctx.expression();
        if (returnExpressionContext != null) {
            TracePointTree returnExpressionTrace = returnExpressionContext.accept(this);
            TracePointTree tracePoint = this.newPoint(TraceType.RETURN, Collections.singletonList(returnExpressionTrace), ctx.getStart());
            this.expressionTracePoints.add(tracePoint);
        } else {
            TracePointTree tracePoint = this.newPoint(TraceType.RETURN, Collections.emptyList(), ctx.getStart());
            this.expressionTracePoints.add(tracePoint);
        }
        return null;
    }

    @Override
    public TracePointTree visitEmptyStatement(QLParser.EmptyStatementContext ctx) {
        this.expressionTracePoints.add(this.newPoint(TraceType.STATEMENT, Collections.emptyList(), ctx.getStart()));
        return null;
    }

    @Override
    public TracePointTree visitBlockStatements(QLParser.BlockStatementsContext ctx) {
        List emptyChildren = ctx.blockStatement().stream().filter(bs -> bs instanceof QLParser.EmptyStatementContext).collect(Collectors.toList());
        if (emptyChildren.size() == ctx.blockStatement().size()) {
            ((QLParser.BlockStatementContext)emptyChildren.get(0)).accept(this);
            return null;
        }
        for (QLParser.BlockStatementContext blockStatementContext : ctx.blockStatement()) {
            if (blockStatementContext instanceof QLParser.EmptyStatementContext) continue;
            blockStatementContext.accept(this);
        }
        return null;
    }

    @Override
    public TracePointTree visitExpression(QLParser.ExpressionContext ctx) {
        QLParser.TernaryExprContext ternaryExprContext = ctx.ternaryExpr();
        if (ternaryExprContext != null) {
            return this.visitTernaryExpr(ternaryExprContext);
        }
        TracePointTree leftChildTree = this.visitLeftHandSide(ctx.leftHandSide());
        TracePointTree rightChildTree = this.visitExpression(ctx.expression());
        return this.newPoint(TraceType.OPERATOR, Arrays.asList(leftChildTree, rightChildTree), ctx.assignOperator().getStart());
    }

    @Override
    public TracePointTree visitLeftHandSide(QLParser.LeftHandSideContext ctx) {
        QLParser.VarIdContext varIdContext = ctx.varId();
        List<QLParser.PathPartContext> pathParts = ctx.pathPart();
        TracePointTree leftChildTree = null;
        int start = 0;
        if (!pathParts.isEmpty() && pathParts.get(0) instanceof QLParser.CallExprContext) {
            QLParser.CallExprContext callExprContext = (QLParser.CallExprContext)pathParts.get(0);
            leftChildTree = this.newPoint(TraceType.FUNCTION, this.traceArgumentList(callExprContext.argumentList()), varIdContext.getStart());
            start = 1;
        } else {
            leftChildTree = this.newPoint(TraceType.VARIABLE, Collections.emptyList(), ctx.getStart());
        }
        return this.pathParts(leftChildTree, pathParts.subList(start, pathParts.size()));
    }

    @Override
    public TracePointTree visitTernaryExpr(QLParser.TernaryExprContext ctx) {
        if (ctx.thenExpr == null) {
            return ctx.condition.accept(this);
        }
        TracePointTree conditionPoint = ctx.condition.accept(this);
        TracePointTree thenPoint = ctx.thenExpr.accept(this);
        TracePointTree elsePoint = ctx.elseExpr.accept(this);
        Token keyToken = ctx.QUESTION().getSymbol();
        return this.newPoint(TraceType.OPERATOR, Arrays.asList(conditionPoint, thenPoint, elsePoint), keyToken);
    }

    @Override
    public TracePointTree visitBaseExpr(QLParser.BaseExprContext ctx) {
        TracePointTree leftChildTree = this.visitPrimary(ctx.primary());
        for (QLParser.LeftAssoContext leftAssoContext : ctx.leftAsso()) {
            Token keyToken = leftAssoContext.binaryop().getStart();
            TracePointTree rightChildTree = this.visitBaseExpr(leftAssoContext.baseExpr());
            leftChildTree = this.newPoint(TraceType.OPERATOR, Arrays.asList(leftChildTree, rightChildTree), keyToken);
        }
        return leftChildTree;
    }

    @Override
    public TracePointTree visitPrimary(QLParser.PrimaryContext ctx) {
        QLParser.PrefixExpressContext prefixExpressContext;
        TracePointTree leftChildTree = this.primaryBaseTrace(ctx);
        QLParser.SuffixExpressContext suffixExpressContext = ctx.suffixExpress();
        if (suffixExpressContext != null) {
            leftChildTree = this.newPoint(TraceType.OPERATOR, Collections.singletonList(leftChildTree), suffixExpressContext.getStart());
        }
        if ((prefixExpressContext = ctx.prefixExpress()) != null) {
            leftChildTree = this.newPoint(TraceType.OPERATOR, Collections.singletonList(leftChildTree), prefixExpressContext.getStart());
        }
        return leftChildTree;
    }

    @Override
    public TracePointTree visitConstExpr(QLParser.ConstExprContext ctx) {
        return this.newPoint(TraceType.VALUE, Collections.emptyList(), ctx.getText(), ctx.getStart());
    }

    @Override
    public TracePointTree visitCastExpr(QLParser.CastExprContext ctx) {
        return ctx.primary().accept(this);
    }

    @Override
    public TracePointTree visitGroupExpr(QLParser.GroupExprContext ctx) {
        return ctx.expression().accept(this);
    }

    @Override
    public TracePointTree visitNewObjExpr(QLParser.NewObjExprContext ctx) {
        return this.newPoint(TraceType.PRIMARY, Collections.emptyList(), ctx.getText(), ctx.getStart());
    }

    @Override
    public TracePointTree visitNewEmptyArrExpr(QLParser.NewEmptyArrExprContext ctx) {
        return this.newPoint(TraceType.PRIMARY, Collections.emptyList(), ctx.getText(), ctx.getStart());
    }

    @Override
    public TracePointTree visitNewInitArrExpr(QLParser.NewInitArrExprContext ctx) {
        return this.newPoint(TraceType.PRIMARY, Collections.emptyList(), ctx.getText(), ctx.getStart());
    }

    @Override
    public TracePointTree visitLambdaExpr(QLParser.LambdaExprContext ctx) {
        return this.newPoint(TraceType.PRIMARY, Collections.emptyList(), ctx.ARROW().getSymbol());
    }

    @Override
    public TracePointTree visitVarIdExpr(QLParser.VarIdExprContext ctx) {
        return this.newPoint(TraceType.VARIABLE, Collections.emptyList(), ctx.getStart());
    }

    @Override
    public TracePointTree visitTypeExpr(QLParser.TypeExprContext ctx) {
        return this.newPoint(TraceType.VALUE, Collections.emptyList(), ctx.getStart());
    }

    @Override
    public TracePointTree visitListExpr(QLParser.ListExprContext ctx) {
        QLParser.ListItemsContext listItemsContext = ctx.listItems();
        if (listItemsContext == null) {
            return this.newPoint(TraceType.LIST, Collections.emptyList(), ctx.getStart());
        }
        List<TracePointTree> children = listItemsContext.expression().stream().map(expression -> expression.accept(this)).collect(Collectors.toList());
        return this.newPoint(TraceType.LIST, children, ctx.getStart());
    }

    @Override
    public TracePointTree visitMapExpr(QLParser.MapExprContext ctx) {
        return this.newPoint(TraceType.MAP, Collections.emptyList(), ctx.getStart());
    }

    @Override
    public TracePointTree visitBlockExpr(QLParser.BlockExprContext ctx) {
        TraceExpressionVisitor traceExpressionVisitor = new TraceExpressionVisitor();
        ctx.blockStatements().accept(traceExpressionVisitor);
        List<TracePointTree> children = traceExpressionVisitor.getExpressionTracePoints();
        return this.newPoint(TraceType.BLOCK, children, ctx.getStart());
    }

    @Override
    public TracePointTree visitQlIf(QLParser.QlIfContext ctx) {
        ArrayList<TracePointTree> children = new ArrayList<TracePointTree>(3);
        children.add(ctx.condition.accept(this));
        children.add(this.visitThenBody(ctx.thenBody()));
        if (ctx.elseBody() != null) {
            children.add(this.visitElseBody(ctx.elseBody()));
        }
        return this.newPoint(TraceType.IF, children, "if", ctx.getStart());
    }

    @Override
    public TracePointTree visitThenBody(QLParser.ThenBodyContext thenBody) {
        if (thenBody.blockStatements() != null) {
            TraceExpressionVisitor blockVisitor = new TraceExpressionVisitor();
            thenBody.blockStatements().accept(blockVisitor);
            return this.newPoint(TraceType.BLOCK, blockVisitor.getExpressionTracePoints(), thenBody.getStart());
        }
        if (thenBody.expression() != null) {
            return thenBody.expression().accept(this);
        }
        if (thenBody.blockStatement() != null) {
            TraceExpressionVisitor blockVisitor = new TraceExpressionVisitor();
            thenBody.blockStatement().accept(blockVisitor);
            return blockVisitor.getExpressionTracePoints().get(0);
        }
        return this.newPoint(TraceType.BLOCK, Collections.emptyList(), thenBody.getStart());
    }

    @Override
    public TracePointTree visitElseBody(QLParser.ElseBodyContext elseBody) {
        if (elseBody.blockStatements() != null) {
            TraceExpressionVisitor blockVisitor = new TraceExpressionVisitor();
            elseBody.blockStatements().accept(blockVisitor);
            return this.newPoint(TraceType.BLOCK, blockVisitor.getExpressionTracePoints(), elseBody.getStart());
        }
        if (elseBody.expression() != null) {
            return elseBody.expression().accept(this);
        }
        if (elseBody.blockStatement() != null) {
            TraceExpressionVisitor blockVisitor = new TraceExpressionVisitor();
            elseBody.blockStatement().accept(blockVisitor);
            return blockVisitor.getExpressionTracePoints().get(0);
        }
        if (elseBody.qlIf() != null) {
            return elseBody.qlIf().accept(this);
        }
        return this.newPoint(TraceType.BLOCK, Collections.emptyList(), elseBody.getStart());
    }

    @Override
    public TracePointTree visitTryCatchExpr(QLParser.TryCatchExprContext ctx) {
        return this.newPoint(TraceType.PRIMARY, Collections.emptyList(), ctx.getStart());
    }

    @Override
    public TracePointTree visitContextSelectExpr(QLParser.ContextSelectExprContext ctx) {
        return this.newPoint(TraceType.PRIMARY, Collections.emptyList(), ctx.getStart());
    }

    private TracePointTree primaryBaseTrace(QLParser.PrimaryContext ctx) {
        QLParser.PrimaryNoFixNonPathableContext primaryNoFixNonPathableContext = ctx.primaryNoFixNonPathable();
        if (primaryNoFixNonPathableContext != null) {
            return primaryNoFixNonPathableContext.accept(this);
        }
        QLParser.PrimaryNoFixPathableContext primaryNoFixPathableContext = ctx.primaryNoFixPathable();
        List<QLParser.PathPartContext> pathPartContexts = ctx.pathPart();
        TracePointTree leftChildTree = null;
        int start = 0;
        if (primaryNoFixPathableContext instanceof QLParser.VarIdExprContext && !pathPartContexts.isEmpty() && pathPartContexts.get(0) instanceof QLParser.CallExprContext) {
            QLParser.VarIdExprContext functionNameContext = (QLParser.VarIdExprContext)primaryNoFixPathableContext;
            QLParser.CallExprContext callExprContext = (QLParser.CallExprContext)pathPartContexts.get(0);
            leftChildTree = this.newPoint(TraceType.FUNCTION, this.traceArgumentList(callExprContext.argumentList()), functionNameContext.getStart());
            start = 1;
        } else {
            leftChildTree = primaryNoFixPathableContext.accept(this);
        }
        return this.pathParts(leftChildTree, pathPartContexts.subList(start, pathPartContexts.size()));
    }

    private TracePointTree pathParts(TracePointTree pathRoot, List<QLParser.PathPartContext> pathPartContexts) {
        TracePointTree leftChildTree = pathRoot;
        for (QLParser.PathPartContext current : pathPartContexts) {
            List<TracePointTree> argumentsChildren;
            QLParser.ArgumentListContext argumentList;
            if (current instanceof QLParser.MethodInvokeContext || current instanceof QLParser.OptionalMethodInvokeContext || current instanceof QLParser.SpreadMethodInvokeContext) {
                argumentList = current.getChild(QLParser.ArgumentListContext.class, 0);
                argumentsChildren = this.traceArgumentList(argumentList);
                ArrayList<TracePointTree> methodChildren = new ArrayList<TracePointTree>(1 + argumentsChildren.size());
                methodChildren.add(leftChildTree);
                methodChildren.addAll(argumentsChildren);
                Token keyToken = current.getChild(QLParser.VarIdContext.class, 0).getStart();
                leftChildTree = this.newPoint(TraceType.METHOD, methodChildren, keyToken);
                continue;
            }
            if (current instanceof QLParser.CallExprContext) {
                argumentList = current.getChild(QLParser.ArgumentListContext.class, 0);
                argumentsChildren = this.traceArgumentList(argumentList);
                ArrayList<TracePointTree> callChildren = new ArrayList<TracePointTree>(1 + argumentsChildren.size());
                callChildren.add(leftChildTree);
                callChildren.addAll(argumentsChildren);
                leftChildTree = this.newPoint(TraceType.OPERATOR, callChildren, current.getStart());
                continue;
            }
            if (current instanceof QLParser.IndexExprContext) {
                QLParser.IndexValueExprContext indexValueExprContext = current.getChild(QLParser.IndexValueExprContext.class, 0);
                List indexArgChildren = indexValueExprContext.getRuleContexts(QLParser.ExpressionContext.class).stream().map(expression -> expression.accept(this)).collect(Collectors.toList());
                ArrayList<TracePointTree> indexChildren = new ArrayList<TracePointTree>(1 + indexArgChildren.size());
                indexChildren.add(leftChildTree);
                indexChildren.addAll(indexArgChildren);
                leftChildTree = this.newPoint(TraceType.OPERATOR, indexChildren, current.getStart());
                continue;
            }
            leftChildTree = this.newPoint(TraceType.FIELD, Collections.singletonList(leftChildTree), current.getStop());
        }
        return leftChildTree;
    }

    private List<TracePointTree> traceArgumentList(QLParser.ArgumentListContext argumentListContext) {
        if (argumentListContext == null || argumentListContext.isEmpty()) {
            return Collections.emptyList();
        }
        return argumentListContext.expression().stream().map(expression -> expression.accept(this)).collect(Collectors.toList());
    }

    private TracePointTree newPoint(TraceType traceType, List<TracePointTree> children, Token keyToken) {
        return new TracePointTree(traceType, keyToken.getText(), children, keyToken.getLine(), keyToken.getCharPositionInLine(), keyToken.getStartIndex());
    }

    private TracePointTree newPoint(TraceType traceType, List<TracePointTree> children, String text, Token keyToken) {
        return new TracePointTree(traceType, text, children, keyToken.getLine(), keyToken.getCharPositionInLine(), keyToken.getStartIndex());
    }
}

