/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.exception;

import com.alibaba.qlexpress4.exception.ExMessageUtil;
import com.alibaba.qlexpress4.exception.QLErrorCodes;
import com.alibaba.qlexpress4.exception.QLRuntimeException;
import com.alibaba.qlexpress4.exception.QLSyntaxException;
import com.alibaba.qlexpress4.exception.QLTimeoutException;
import com.alibaba.qlexpress4.exception.lsp.Diagnostic;
import com.alibaba.qlexpress4.exception.lsp.Position;
import com.alibaba.qlexpress4.exception.lsp.Range;

public class QLException
extends RuntimeException {
    private final Diagnostic diagnostic;

    protected QLException(String message, Diagnostic diagnostic) {
        super(message);
        this.diagnostic = diagnostic;
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public int getPos() {
        return this.diagnostic.getPos();
    }

    public String getReason() {
        return this.diagnostic.getMessage();
    }

    public int getLineNo() {
        return this.diagnostic.getRange().getStart().getLine() + 1;
    }

    public int getColNo() {
        return this.diagnostic.getRange().getStart().getCharacter() + 1;
    }

    public String getErrLexeme() {
        return this.diagnostic.getLexeme();
    }

    public String getErrorCode() {
        return this.diagnostic.getCode();
    }

    public static QLSyntaxException reportScannerErr(String script, int tokenStartPos, int line, int col, String lexeme, String errorCode, String reason) {
        ExMessageUtil.ExMessage exMessage = ExMessageUtil.format(script, tokenStartPos, line, col, lexeme, errorCode, reason);
        Diagnostic diagnostic = QLException.toDiagnostic(tokenStartPos, line, col, lexeme, errorCode, reason, exMessage.getSnippet());
        return new QLSyntaxException(exMessage.getMessage(), diagnostic);
    }

    public static QLRuntimeException reportRuntimeErrWithAttach(String script, int tokenStartPos, int line, int col, String lexeme, String errorCode, String reason, Object catchObj) {
        ExMessageUtil.ExMessage exMessage = ExMessageUtil.format(script, tokenStartPos, line, col, lexeme, errorCode, reason);
        Diagnostic diagnostic = QLException.toDiagnostic(tokenStartPos, line, col, lexeme, errorCode, reason, exMessage.getSnippet());
        return errorCode.equals(QLErrorCodes.SCRIPT_TIME_OUT.name()) ? new QLTimeoutException(catchObj, exMessage.getMessage(), diagnostic) : new QLRuntimeException(catchObj, exMessage.getMessage(), diagnostic);
    }

    private static Diagnostic toDiagnostic(int startPos, int line, int col, String lexeme, String errorCode, String reason, String snippet) {
        int zeroBasedLine = line - 1;
        int zeroBasedCol = col - 1;
        Position start = new Position(zeroBasedLine, zeroBasedCol);
        Position end = new Position(zeroBasedLine, zeroBasedCol + lexeme.length());
        Range range = new Range(start, end);
        return new Diagnostic(startPos, range, lexeme, errorCode, reason, snippet);
    }
}

