/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime;

import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.Value;

public class FixedSizeStack {
    private final Value[] elements;
    private int cursor = 0;

    public FixedSizeStack(int size) {
        this.elements = new Value[size];
    }

    public void push(Value ele) {
        this.elements[this.cursor++] = ele;
    }

    public Value pop() {
        return this.elements[--this.cursor];
    }

    public Value peak() {
        return this.elements[this.cursor - 1];
    }

    public Parameters pop(int n) {
        this.cursor -= n;
        return new StackSwapParameters(this.elements, this.cursor, n);
    }

    private static class StackSwapParameters
    implements Parameters {
        private final Value[] elements;
        private final int start;
        private final int length;

        private StackSwapParameters(Value[] elements, int start, int length) {
            this.elements = elements;
            this.start = start;
            this.length = length;
        }

        @Override
        public Value get(int i) {
            return i >= this.length ? null : this.elements[this.start + i];
        }

        @Override
        public int size() {
            return this.length;
        }
    }
}

