/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime;

import com.alibaba.qlexpress4.annotation.QLAlias;
import com.alibaba.qlexpress4.runtime.Nothing;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.utils.BasicUtil;
import com.alibaba.qlexpress4.utils.CacheUtil;
import com.alibaba.qlexpress4.utils.QLAliasUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class MemberResolver {
    public static Constructor<?> resolveConstructor(Class<?> cls, Class<?>[] argTypes) {
        Constructor<?>[] constructors = cls.getConstructors();
        Class[][] candidates = new Class[constructors.length][];
        for (int i = 0; i < constructors.length; ++i) {
            candidates[i] = constructors[i].getParameterTypes();
        }
        Integer bestIndex = MemberResolver.resolveBestMatch(candidates, argTypes);
        if (bestIndex != null) {
            return constructors[bestIndex];
        }
        ArrayList<Class<?>[]> varArgsCandidates = new ArrayList<Class<?>[]>(constructors.length);
        ArrayList<Integer> varArgsConstructorI = new ArrayList<Integer>(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            if (!constructor.isVarArgs()) continue;
            varArgsCandidates.add(MemberResolver.adapt2VarArgTypes(constructor.getParameterTypes(), argTypes.length));
            varArgsConstructorI.add(i);
        }
        Integer varArgBestIndex = MemberResolver.resolveBestMatch((Class[][])varArgsCandidates.toArray((T[])new Class[0][]), argTypes);
        if (varArgBestIndex == null) {
            return null;
        }
        return constructors[(Integer)varArgsConstructorI.get(varArgBestIndex)];
    }

    public static boolean methodExist(Class<?> cls, String name, boolean isStatic, boolean allowPrivate) {
        Class<?> curCls = cls;
        while (curCls != null) {
            Method[] declaredMethods = MemberResolver.getDeclaredMethod(curCls, name, isStatic, allowPrivate);
            if (declaredMethods.length > 0) {
                return true;
            }
            curCls = cls.getSuperclass();
        }
        return false;
    }

    public static Method resolveMethod(Class<?> cls, String methodName, Class<?>[] argTypes, boolean isStatic, boolean allowPrivate) {
        for (Class<?> curCls = cls; curCls != null; curCls = curCls.getSuperclass()) {
            Method method = MemberResolver.resolveDeclaredMethod(curCls, methodName, argTypes, isStatic, allowPrivate);
            if (method == null) continue;
            return method;
        }
        return MemberResolver.resolveIntersMethod(cls.getInterfaces(), methodName, argTypes, isStatic);
    }

    private static Method resolveIntersMethod(Class<?>[] inters, String methodName, Class<?>[] argTypes, boolean isStatic) {
        for (Class<?> inter : inters) {
            Method method = MemberResolver.resolveInterMethod(inter, methodName, argTypes, isStatic);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method resolveInterMethod(Class<?> inter, String methodName, Class<?>[] argTypes, boolean isStatic) {
        Method method = MemberResolver.resolveDeclaredMethod(inter, methodName, argTypes, isStatic, false);
        if (method != null) {
            return method;
        }
        return MemberResolver.resolveIntersMethod(inter.getInterfaces(), methodName, argTypes, isStatic);
    }

    public static int resolvePriority(Class<?>[] paramTypes, Class<?>[] argTypes) {
        if (paramTypes.length != argTypes.length) {
            return MatchPriority.MISMATCH.priority;
        }
        int methodPriority = MatchPriority.EQUAL.priority;
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Class<?> argType = argTypes[i];
            int paramPriority = MemberResolver.resolveArgPriority(paramType, argType);
            if (paramPriority == MatchPriority.MISMATCH.priority) {
                return paramPriority;
            }
            if (paramPriority >= methodPriority) continue;
            methodPriority = paramPriority;
        }
        return methodPriority;
    }

    private static Method resolveDeclaredMethod(Class<?> cls, String methodName, Class<?>[] argTypes, boolean isStatic, boolean allowPrivate) {
        Method[] declaredMethods = MemberResolver.getDeclaredMethod(cls, methodName, isStatic, allowPrivate);
        Class[][] candidates = new Class[declaredMethods.length][];
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            candidates[i] = declaredMethod.getParameterTypes();
        }
        Integer bestIndex = MemberResolver.resolveBestMatch(candidates, argTypes);
        if (bestIndex != null) {
            return declaredMethods[bestIndex];
        }
        ArrayList<Class<?>[]> varArgsCandidates = new ArrayList<Class<?>[]>(declaredMethods.length);
        ArrayList<Integer> varArgsMethodI = new ArrayList<Integer>(declaredMethods.length);
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            if (!declaredMethod.isVarArgs()) continue;
            varArgsCandidates.add(MemberResolver.adapt2VarArgTypes(declaredMethod.getParameterTypes(), argTypes.length));
            varArgsMethodI.add(i);
        }
        Integer varArgBestIndex = MemberResolver.resolveBestMatch((Class[][])varArgsCandidates.toArray((T[])new Class[0][]), argTypes);
        if (varArgBestIndex == null) {
            return null;
        }
        return declaredMethods[(Integer)varArgsMethodI.get(varArgBestIndex)];
    }

    private static Method[] getDeclaredMethod(Class<?> cls, String methodName, boolean isStatic, boolean allowPrivate) {
        Method[] declaredMethods = cls.getDeclaredMethods();
        ArrayList<Method> result = new ArrayList<Method>(declaredMethods.length);
        for (Method declaredMethod : declaredMethods) {
            if (Modifier.isAbstract(declaredMethod.getModifiers()) || !methodName.equals(declaredMethod.getName()) && !QLAliasUtils.matchQLAlias(methodName, (QLAlias[])declaredMethod.getAnnotationsByType(QLAlias.class)) || isStatic && !BasicUtil.isStatic(declaredMethod) || !allowPrivate && !BasicUtil.isPublic(declaredMethod)) continue;
            result.add(declaredMethod);
        }
        return result.toArray(new Method[0]);
    }

    private static Class<?>[] adapt2VarArgTypes(Class<?>[] parameterTypes, int argLength) {
        Class<?> varItemType = parameterTypes[parameterTypes.length - 1].getComponentType();
        Class[] varParamTypes = new Class[argLength];
        System.arraycopy(parameterTypes, 0, varParamTypes, 0, parameterTypes.length - 1);
        for (int i = parameterTypes.length - 1; i < argLength; ++i) {
            varParamTypes[i] = varItemType;
        }
        return varParamTypes;
    }

    public static Integer resolveBestMatch(Class<?>[][] candidates, Class<?>[] argTypes) {
        Integer bestMatchIndex = null;
        int bestPriority = MatchPriority.MISMATCH.priority;
        for (int i = 0; i < candidates.length; ++i) {
            Class<?>[] candidate = candidates[i];
            int priority = MemberResolver.resolvePriority(candidate, argTypes);
            if (priority <= bestPriority) continue;
            bestPriority = priority;
            bestMatchIndex = i;
        }
        return bestMatchIndex;
    }

    private static int resolveArgPriority(Class<?> paramType, Class<?> argType) {
        Class<?> primitiveParamCls;
        if (paramType == argType) {
            return MatchPriority.EQUAL.priority;
        }
        if (CacheUtil.isFunctionInterface(paramType) && QLambda.class.isAssignableFrom(argType)) {
            return MatchPriority.LAMBDA.priority;
        }
        Class<?> primitiveArgCls = argType.isPrimitive() ? argType : BasicUtil.transToPrimitive(argType);
        Class<?> clazz = primitiveParamCls = paramType.isPrimitive() ? paramType : BasicUtil.transToPrimitive(paramType);
        if (primitiveArgCls != null && primitiveArgCls == primitiveParamCls) {
            return MatchPriority.UNBOX.priority;
        }
        Integer paramNumLevel = BasicUtil.numberPromoteLevel(paramType);
        Integer argNumLevel = BasicUtil.numberPromoteLevel(argType);
        if (paramNumLevel != null && argNumLevel != null) {
            return paramNumLevel >= argNumLevel ? MatchPriority.NUMBER_PROMOTION.priority + argNumLevel - paramNumLevel : MatchPriority.NUMBER_DEMOTION.priority;
        }
        if (argType.isPrimitive() && paramType == Object.class) {
            return MatchPriority.EXTEND.priority;
        }
        if (argType == Nothing.class || paramType.isAssignableFrom(argType)) {
            return MatchPriority.EXTEND.priority;
        }
        return MatchPriority.MISMATCH.priority;
    }

    public static enum MatchPriority {
        MISMATCH(-1),
        EXTEND(0),
        NUMBER_DEMOTION(9),
        NUMBER_PROMOTION(8),
        UNBOX(9),
        LAMBDA(10),
        EQUAL(11);

        public final int priority;

        private MatchPriority(int priority) {
            this.priority = priority;
        }
    }
}

