/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.UserDefineException;
import com.alibaba.qlexpress4.runtime.DelegateQContext;
import com.alibaba.qlexpress4.runtime.ExceptionTable;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QLambdaDefinitionInner;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.AssignableDataValue;
import com.alibaba.qlexpress4.runtime.data.convert.ObjTypeConvertor;
import com.alibaba.qlexpress4.runtime.function.CustomFunction;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.runtime.scope.QScope;
import com.alibaba.qlexpress4.runtime.scope.QvmBlockScope;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QLambdaInner
implements QLambda {
    private final QLambdaDefinitionInner lambdaDefinition;
    private final QContext qContext;
    private final QLOptions qlOptions;
    private final boolean newEnv;

    public QLambdaInner(QLambdaDefinitionInner lambdaDefinition, QContext qContext, QLOptions qlOptions, boolean newEnv) {
        this.lambdaDefinition = lambdaDefinition;
        this.qContext = qContext;
        this.qlOptions = qlOptions;
        this.newEnv = newEnv;
    }

    @Override
    public QResult call(Object ... params) throws Throwable {
        return this.callInner(this.newEnv ? this.inheritScope(params) : this.qContext);
    }

    @Override
    public Map<String, CustomFunction> getFunctionDefined(Object ... params) throws Throwable {
        QContext newRuntime = this.newEnv ? this.inheritScope(params) : this.qContext;
        this.callInner(newRuntime);
        return newRuntime.getFunctionTable();
    }

    private QResult callInner(QContext runtime) {
        QLInstruction[] instructions = this.lambdaDefinition.getInstructions();
        block4: for (int i = 0; i < instructions.length; ++i) {
            QResult qResult = instructions[i].execute(runtime, this.qlOptions);
            switch (qResult.getResultType()) {
                case JUMP: {
                    i += ((Integer)qResult.getResult().get()).intValue();
                    continue block4;
                }
                case RETURN: 
                case BREAK: 
                case CONTINUE: {
                    return qResult;
                }
            }
        }
        return QResult.NEXT_INSTRUCTION;
    }

    private QContext inheritScope(Object[] params) throws UserDefineException {
        QLambdaDefinitionInner.Param paramDefinition;
        int i;
        HashMap<String, Value> initSymbolTable = new HashMap<String, Value>(params.length);
        List<QLambdaDefinitionInner.Param> paramsDefinition = this.lambdaDefinition.getParamsType();
        for (i = 0; i < Math.min(params.length, paramsDefinition.size()); ++i) {
            Object originParamI = params[i];
            paramDefinition = paramsDefinition.get(i);
            Class<?> targetCls = paramDefinition.getClazz();
            ObjTypeConvertor.QConverted qlConvertResult = ObjTypeConvertor.cast(originParamI, targetCls);
            if (!qlConvertResult.isConvertible()) {
                throw new UserDefineException(UserDefineException.ExceptionType.INVALID_ARGUMENT, MessageFormat.format("invalid argument at index {0} (start from 0), required type {1}, but {2} provided", i, targetCls.getName(), originParamI == null ? "null" : originParamI.getClass().getName()));
            }
            initSymbolTable.put(paramDefinition.getName(), new AssignableDataValue(paramDefinition.getName(), qlConvertResult.getConverted(), targetCls));
        }
        for (i = params.length; i < paramsDefinition.size(); ++i) {
            paramDefinition = paramsDefinition.get(i);
            initSymbolTable.put(paramDefinition.getName(), new AssignableDataValue(paramDefinition.getName(), null, paramDefinition.getClazz()));
        }
        QvmBlockScope newScope = new QvmBlockScope((QScope)this.qContext, initSymbolTable, this.lambdaDefinition.getMaxStackSize(), ExceptionTable.EMPTY);
        return new DelegateQContext(this.qContext, newScope);
    }
}

