/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.data.convert;

import com.alibaba.qlexpress4.proxy.QLambdaInvocationHandler;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.operator.number.NumberMath;
import com.alibaba.qlexpress4.utils.CacheUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ObjTypeConvertor {
    public static QConverted cast(Object value, Class<?> type) {
        if (ObjTypeConvertor.noNeedConvert(value, type)) {
            return ObjTypeConvertor.converted(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return ObjTypeConvertor.castChar(value);
        }
        if (CacheUtil.isFunctionInterface(type)) {
            return ObjTypeConvertor.castFunctionInter(value, type);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (value instanceof Boolean) {
                return ObjTypeConvertor.converted(value);
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == Byte.TYPE || type == Byte.class) {
            if (value instanceof Byte) {
                return ObjTypeConvertor.converted(value);
            }
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(((Number)value).byteValue());
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == Short.TYPE || type == Short.class) {
            if (value instanceof Short) {
                return ObjTypeConvertor.converted(value);
            }
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(((Number)value).shortValue());
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (value instanceof Integer) {
                return ObjTypeConvertor.converted(value);
            }
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(((Number)value).intValue());
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == Long.TYPE || type == Long.class) {
            if (value instanceof Long) {
                return ObjTypeConvertor.converted(value);
            }
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(((Number)value).longValue());
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == Float.TYPE || type == Float.class) {
            if (value instanceof Float) {
                return ObjTypeConvertor.converted(value);
            }
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(Float.valueOf(((Number)value).floatValue()));
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == Double.TYPE || type == Double.class) {
            if (value instanceof Double) {
                return ObjTypeConvertor.converted(value);
            }
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(((Number)value).doubleValue());
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == BigInteger.class) {
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(NumberMath.toBigInteger((Number)value));
            }
            return ObjTypeConvertor.unConvertible();
        }
        if (type == BigDecimal.class) {
            if (value instanceof Number) {
                return ObjTypeConvertor.converted(NumberMath.toBigDecimal((Number)value));
            }
            return ObjTypeConvertor.unConvertible();
        }
        return ObjTypeConvertor.unConvertible();
    }

    private static QConverted castFunctionInter(Object value, Class<?> functionInter) {
        if (value instanceof QLambda) {
            return ObjTypeConvertor.converted(Proxy.newProxyInstance(functionInter.getClassLoader(), new Class[]{functionInter}, (InvocationHandler)new QLambdaInvocationHandler((QLambda)value)));
        }
        return ObjTypeConvertor.unConvertible();
    }

    private static QConverted castChar(Object value) {
        if (value instanceof Character) {
            return ObjTypeConvertor.converted(value);
        }
        if (value instanceof Number) {
            return ObjTypeConvertor.converted(Character.valueOf((char)((Number)value).intValue()));
        }
        if (value instanceof String) {
            String strValue = (String)value;
            if (strValue.length() == 1) {
                return ObjTypeConvertor.converted(Character.valueOf(strValue.charAt(0)));
            }
            return ObjTypeConvertor.unConvertible();
        }
        return ObjTypeConvertor.unConvertible();
    }

    private static boolean noNeedConvert(Object value, Class<?> type) {
        return type == null || value == null || type.isInstance(value);
    }

    private static QConverted converted(Object converted) {
        return new QConverted(true, converted);
    }

    private static QConverted unConvertible() {
        return new QConverted(false, null);
    }

    public static class QConverted {
        private final boolean convertible;
        private final Object converted;

        public QConverted(boolean convertible, Object converted) {
            this.convertible = convertible;
            this.converted = converted;
        }

        public boolean isConvertible() {
            return this.convertible;
        }

        public Object getConverted() {
            return this.converted;
        }
    }
}

