/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QLambda;
import com.alibaba.qlexpress4.runtime.QLambdaDefinition;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.function.QLambdaFunction;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.function.Consumer;

public class DefineFunctionInstruction
extends QLInstruction {
    private final String name;
    private final QLambdaDefinition lambdaDefinition;

    public DefineFunctionInstruction(ErrorReporter errorReporter, String name, QLambdaDefinition lambdaDefinition) {
        super(errorReporter);
        this.name = name;
        this.lambdaDefinition = lambdaDefinition;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        QLambda lambda = this.lambdaDefinition.toLambda(qContext, qlOptions, true);
        qContext.defineFunction(this.name, new QLambdaFunction(lambda));
        return QResult.NEXT_INSTRUCTION;
    }

    @Override
    public int stackInput() {
        return 0;
    }

    @Override
    public int stackOutput() {
        return 0;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": DefineFunction " + this.name, debug);
        this.lambdaDefinition.println(depth + 1, debug);
    }
}

