/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;

public class NewMapInstruction
extends QLInstruction {
    private final List<String> keys;

    public NewMapInstruction(ErrorReporter errorReporter, List<String> keys) {
        super(errorReporter);
        this.keys = keys;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        Parameters initItems = qContext.pop(this.keys.size());
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.keys.size(); ++i) {
            m.put(this.keys.get(i), initItems.get(i).get());
        }
        qContext.push(new DataValue(m));
        return QResult.NEXT_INSTRUCTION;
    }

    @Override
    public int stackInput() {
        return this.keys.size();
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": NewMap by keys " + this.keys, debug);
    }
}

