/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.instruction;

import com.alibaba.qlexpress4.QLOptions;
import com.alibaba.qlexpress4.exception.ErrorReporter;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.QContext;
import com.alibaba.qlexpress4.runtime.QResult;
import com.alibaba.qlexpress4.runtime.data.DataValue;
import com.alibaba.qlexpress4.runtime.instruction.QLInstruction;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.function.Consumer;

public class StringJoinInstruction
extends QLInstruction {
    private final int n;

    public StringJoinInstruction(ErrorReporter errorReporter, int n) {
        super(errorReporter);
        this.n = n;
    }

    @Override
    public QResult execute(QContext qContext, QLOptions qlOptions) {
        Parameters arguments = qContext.pop(this.n);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.n; ++i) {
            sb.append(arguments.get(i).get());
        }
        qContext.push(new DataValue(sb.toString()));
        return QResult.NEXT_INSTRUCTION;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public int stackInput() {
        return this.n;
    }

    @Override
    public int stackOutput() {
        return 1;
    }

    @Override
    public void println(int index, int depth, Consumer<String> debug) {
        PrintlnUtils.printlnByCurDepth(depth, index + ": StringJoin " + this.n, debug);
    }
}

