/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.scope;

import com.alibaba.qlexpress4.runtime.ExceptionTable;
import com.alibaba.qlexpress4.runtime.FixedSizeStack;
import com.alibaba.qlexpress4.runtime.Parameters;
import com.alibaba.qlexpress4.runtime.Value;
import com.alibaba.qlexpress4.runtime.data.AssignableDataValue;
import com.alibaba.qlexpress4.runtime.function.CustomFunction;
import com.alibaba.qlexpress4.runtime.scope.QScope;
import java.util.HashMap;
import java.util.Map;

public class QvmBlockScope
implements QScope {
    private final QScope parent;
    private final Map<String, Value> symbolTable;
    private final Map<String, CustomFunction> functionTable;
    private final FixedSizeStack opStack;
    private final ExceptionTable exceptionTable;

    public QvmBlockScope(QScope parent, Map<String, Value> symbolTable, int maxStackSize, ExceptionTable exceptionTable) {
        this(parent, symbolTable, new FixedSizeStack(maxStackSize), exceptionTable);
    }

    public QvmBlockScope(QScope parent, Map<String, Value> symbolTable, FixedSizeStack reuseStack, ExceptionTable exceptionTable) {
        this.parent = parent;
        this.symbolTable = symbolTable;
        this.functionTable = new HashMap<String, CustomFunction>();
        this.opStack = reuseStack;
        this.exceptionTable = exceptionTable;
    }

    @Override
    public Value getSymbol(String varName) {
        Value localSymbol = this.symbolTable.get(varName);
        return localSymbol != null ? localSymbol : this.parent.getSymbol(varName);
    }

    @Override
    public void defineLocalSymbol(String varName, Class<?> varClz, Object value) {
        this.symbolTable.put(varName, new AssignableDataValue(varName, value, varClz));
    }

    @Override
    public void defineFunction(String functionName, CustomFunction function) {
        this.functionTable.put(functionName, function);
    }

    @Override
    public CustomFunction getFunction(String functionName) {
        CustomFunction function = this.functionTable.get(functionName);
        return function == null ? this.parent.getFunction(functionName) : function;
    }

    @Override
    public Map<String, CustomFunction> getFunctionTable() {
        return this.functionTable;
    }

    @Override
    public void push(Value value) {
        this.opStack.push(value);
    }

    @Override
    public Parameters pop(int number) {
        return this.opStack.pop(number);
    }

    @Override
    public Value pop() {
        return this.opStack.pop();
    }

    @Override
    public Value peek() {
        return this.opStack.peak();
    }

    @Override
    public QScope getParent() {
        return this.parent;
    }

    @Override
    public QScope newScope() {
        return new QvmBlockScope((QScope)this, new HashMap<String, Value>(), this.opStack, this.exceptionTable);
    }
}

