/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.trace;

import com.alibaba.qlexpress4.runtime.trace.TraceType;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.List;

public class ExpressionTrace {
    private final TraceType type;
    private final String token;
    private Object value;
    private boolean evaluated;
    private final List<ExpressionTrace> children;
    private final int line;
    private final int col;
    private final int position;

    public ExpressionTrace(TraceType type, String token, List<ExpressionTrace> children, Integer line, Integer col, Integer position) {
        this.type = type;
        this.token = token;
        this.children = children;
        this.line = line;
        this.col = col;
        this.position = position;
    }

    public String toPrettyString(int indent) {
        StringBuilder nodeStringBuilder = new StringBuilder(PrintlnUtils.buildIndentString(indent, (Object)((Object)this.type) + " " + this.token + " " + (this.evaluated ? this.value : ""))).append('\n');
        for (ExpressionTrace child : this.children) {
            nodeStringBuilder.append(child.toPrettyString(indent + 2));
        }
        return nodeStringBuilder.toString();
    }

    public void valueEvaluated(Object value) {
        this.value = value;
        this.evaluated = true;
    }

    public TraceType getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public List<ExpressionTrace> getChildren() {
        return this.children;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public int getPosition() {
        return this.position;
    }
}

