/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.qlexpress4.runtime.trace;

import com.alibaba.qlexpress4.runtime.trace.TraceType;
import com.alibaba.qlexpress4.utils.PrintlnUtils;
import java.util.List;

public class TracePointTree {
    private final TraceType type;
    private final String token;
    private final List<TracePointTree> children;
    private final int line;
    private final int col;
    private final int position;

    public TracePointTree(TraceType type, String token, List<TracePointTree> children, int line, int col, int position) {
        this.type = type;
        this.token = token;
        this.children = children;
        this.line = line;
        this.col = col;
        this.position = position;
    }

    public String toPrettyString(int indent) {
        StringBuilder nodeStringBuilder = new StringBuilder(PrintlnUtils.buildIndentString(indent, (Object)((Object)this.type) + " " + this.token)).append('\n');
        for (TracePointTree child : this.children) {
            nodeStringBuilder.append(child.toPrettyString(indent + 2));
        }
        return nodeStringBuilder.toString();
    }

    public TraceType getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public List<TracePointTree> getChildren() {
        return this.children;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public int getPosition() {
        return this.position;
    }
}

