/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.common.lang;

import com.alibaba.common.lang.ClassInstantiationException;
import com.alibaba.common.lang.ClassUtil;
import com.alibaba.common.lang.ServiceNotFoundException;
import com.alibaba.common.lang.StringUtil;
import com.alibaba.common.lang.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ClassLoaderUtil {
    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtil.loadClass(className, ClassLoaderUtil.getContextClassLoader());
    }

    public static Class loadClass(String className, Class referrer) throws ClassNotFoundException {
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        return ClassLoaderUtil.loadClass(className, classLoader);
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (classLoader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, classLoader);
    }

    public static Class loadServiceClass(String serviceId) throws ClassNotFoundException {
        return ClassLoaderUtil.loadServiceClass(serviceId, ClassLoaderUtil.getContextClassLoader());
    }

    public static Class loadServiceClass(String serviceId, Class referrer) throws ClassNotFoundException {
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        return ClassLoaderUtil.loadServiceClass(serviceId, classLoader);
    }

    public static Class loadServiceClass(String serviceId, ClassLoader classLoader) throws ClassNotFoundException {
        String serviceClassName;
        if (serviceId == null) {
            return null;
        }
        serviceId = "META-INF/services/" + serviceId;
        InputStream istream = ClassLoaderUtil.getResourceAsStream(serviceId, classLoader);
        if (istream == null) {
            throw new ServiceNotFoundException("Could not find " + serviceId);
        }
        try {
            serviceClassName = StringUtil.trimToEmpty(StreamUtil.readText(istream, "UTF-8"));
        }
        catch (IOException e) {
            throw new ServiceNotFoundException("Failed to load " + serviceId, e);
        }
        return ClassLoaderUtil.loadClass(serviceClassName, classLoader);
    }

    public static Class loadServiceClass(String className, String serviceId) throws ClassNotFoundException {
        return ClassLoaderUtil.loadServiceClass(className, serviceId, ClassLoaderUtil.getContextClassLoader());
    }

    public static Class loadServiceClass(String className, String serviceId, Class referrer) throws ClassNotFoundException {
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        return ClassLoaderUtil.loadServiceClass(className, serviceId, classLoader);
    }

    public static Class loadServiceClass(String className, String serviceId, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            if (className != null) {
                return ClassLoaderUtil.loadClass(className, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ClassLoaderUtil.loadServiceClass(serviceId, classLoader);
    }

    private static ClassLoader getReferrerClassLoader(Class referrer) {
        ClassLoader classLoader = null;
        if (referrer != null && (classLoader = referrer.getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Object newInstance(String className) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadClass(className));
    }

    public static Object newInstance(String className, Class referrer) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadClass(className, referrer));
    }

    public static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadClass(className, classLoader));
    }

    private static Object newInstance(Class clazz) throws ClassInstantiationException {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ClassInstantiationException("Failed to instantiate class: " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ClassInstantiationException("Failed to instantiate class: " + clazz.getName(), e);
        }
        catch (Exception e) {
            throw new ClassInstantiationException("Failed to instantiate class: " + clazz.getName(), e);
        }
    }

    public static Object newServiceInstance(String serviceId) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadServiceClass(serviceId));
    }

    public static Object newServiceInstance(String serviceId, Class referrer) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadServiceClass(serviceId, referrer));
    }

    public static Object newServiceInstance(String serviceId, ClassLoader classLoader) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadServiceClass(serviceId, classLoader));
    }

    public static Object newServiceInstance(String className, String serviceId) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadServiceClass(className, serviceId));
    }

    public static Object newServiceInstance(String className, String serviceId, Class referrer) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadServiceClass(className, serviceId, referrer));
    }

    public static Object newServiceInstance(String className, String serviceId, ClassLoader classLoader) throws ClassNotFoundException, ClassInstantiationException {
        return ClassLoaderUtil.newInstance(ClassLoaderUtil.loadServiceClass(className, serviceId, classLoader));
    }

    public static URL[] getResources(String resourceName) {
        LinkedList urls = new LinkedList();
        boolean found = false;
        found = ClassLoaderUtil.getResources(urls, resourceName, ClassLoaderUtil.getContextClassLoader(), false);
        if (!found) {
            ClassLoaderUtil.getResources(urls, resourceName, ClassLoaderUtil.class.getClassLoader(), false);
        }
        if (!found) {
            ClassLoaderUtil.getResources(urls, resourceName, null, true);
        }
        return ClassLoaderUtil.getDistinctURLs(urls);
    }

    public static URL[] getResources(String resourceName, Class referrer) {
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        LinkedList urls = new LinkedList();
        ClassLoaderUtil.getResources(urls, resourceName, classLoader, classLoader == null);
        return ClassLoaderUtil.getDistinctURLs(urls);
    }

    public static URL[] getResources(String resourceName, ClassLoader classLoader) {
        LinkedList urls = new LinkedList();
        ClassLoaderUtil.getResources(urls, resourceName, classLoader, classLoader == null);
        return ClassLoaderUtil.getDistinctURLs(urls);
    }

    private static boolean getResources(List urlSet, String resourceName, ClassLoader classLoader, boolean sysClassLoader) {
        if (resourceName == null) {
            return false;
        }
        Enumeration<URL> i = null;
        try {
            if (classLoader != null) {
                i = classLoader.getResources(resourceName);
            } else if (sysClassLoader) {
                i = ClassLoader.getSystemResources(resourceName);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (i != null && i.hasMoreElements()) {
            while (i.hasMoreElements()) {
                urlSet.add(i.nextElement());
            }
            return true;
        }
        return false;
    }

    private static URL[] getDistinctURLs(LinkedList urls) {
        if (urls == null || urls.size() == 0) {
            return new URL[0];
        }
        HashSet<URL> urlSet = new HashSet<URL>(urls.size());
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            if (urlSet.contains(url)) {
                i.remove();
                continue;
            }
            urlSet.add(url);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static URL getResource(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        ClassLoader classLoader = null;
        URL url = null;
        classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        classLoader = ClassLoaderUtil.class.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resourceName);
    }

    public static URL getResource(String resourceName, Class referrer) {
        if (resourceName == null) {
            return null;
        }
        ClassLoader classLoader = ClassLoaderUtil.getReferrerClassLoader(referrer);
        return classLoader == null ? ClassLoaderUtil.class.getClassLoader().getResource(resourceName) : classLoader.getResource(resourceName);
    }

    public static URL getResource(String resourceName, ClassLoader classLoader) {
        if (resourceName == null) {
            return null;
        }
        return classLoader == null ? ClassLoaderUtil.class.getClassLoader().getResource(resourceName) : classLoader.getResource(resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        URL url = ClassLoaderUtil.getResource(resourceName);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName, Class referrer) {
        URL url = ClassLoaderUtil.getResource(resourceName, referrer);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader classLoader) {
        URL url = ClassLoaderUtil.getResource(resourceName, classLoader);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static URL[] whichClasses(String className) {
        return ClassLoaderUtil.getResources(ClassUtil.getClassNameAsResource(className));
    }

    public static URL[] whichClasses(String className, Class referrer) {
        return ClassLoaderUtil.getResources(ClassUtil.getClassNameAsResource(className), referrer);
    }

    public static URL[] whichClasses(String className, ClassLoader classLoader) {
        return ClassLoaderUtil.getResources(ClassUtil.getClassNameAsResource(className), classLoader);
    }

    public static URL whichClass(String className) {
        return ClassLoaderUtil.getResource(ClassUtil.getClassNameAsResource(className));
    }

    public static URL whichClass(String className, Class referrer) {
        return ClassLoaderUtil.getResource(ClassUtil.getClassNameAsResource(className), referrer);
    }

    public static URL whichClass(String className, ClassLoader classLoader) {
        return ClassLoaderUtil.getResource(ClassUtil.getClassNameAsResource(className), classLoader);
    }
}

