/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.common.lang;

import com.alibaba.common.lang.StringUtil;
import com.alibaba.common.lang.i18n.LocaleUtil;
import com.alibaba.common.lang.internal.Entities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;

public class StringEscapeUtil {
    private static final BitSet ALPHA;
    private static final BitSet ALPHANUM;
    private static final BitSet MARK;
    private static final BitSet RESERVED;
    private static final BitSet UNRESERVED;
    private static int[] HEXADECIMAL;

    public static String escapeJava(String str) {
        return StringEscapeUtil.escapeJavaStyleString(str, false, false);
    }

    public static String escapeJava(String str, boolean strict) {
        return StringEscapeUtil.escapeJavaStyleString(str, false, strict);
    }

    public static void escapeJava(String str, Writer out) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, false, out, false);
    }

    public static void escapeJava(String str, Writer out, boolean strict) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, false, out, strict);
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtil.escapeJavaStyleString(str, true, false);
    }

    public static String escapeJavaScript(String str, boolean strict) {
        return StringEscapeUtil.escapeJavaStyleString(str, true, strict);
    }

    public static void escapeJavaScript(String str, Writer out) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, true, out, false);
    }

    public static void escapeJavaScript(String str, Writer out, boolean strict) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, true, out, strict);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes, boolean strict) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter out = new StringWriter(str.length() * 2);
            if (StringEscapeUtil.escapeJavaStyleString(str, escapeSingleQuotes, out, strict)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean escapeJavaStyleString(String str, boolean escapeSingleQuote, Writer out, boolean strict) throws IOException {
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        int length = str.length();
        block12: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + Integer.toHexString(ch).toUpperCase());
                            break;
                        }
                        out.write("\\u000" + Integer.toHexString(ch).toUpperCase());
                    }
                }
                needToChange = true;
                continue;
            }
            if (strict && ch > '\u00ff') {
                if (ch > '\u0fff') {
                    out.write("\\u" + Integer.toHexString(ch).toUpperCase());
                } else {
                    out.write("\\u0" + Integer.toHexString(ch).toUpperCase());
                }
                needToChange = true;
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                        needToChange = true;
                    }
                    out.write(39);
                    continue block12;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    needToChange = true;
                    continue block12;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    needToChange = true;
                    continue block12;
                }
                default: {
                    out.write(ch);
                }
            }
        }
        return needToChange;
    }

    public static String unescapeJava(String str) {
        return StringEscapeUtil.unescapeJavaStyleString(str);
    }

    public static void unescapeJava(String str, Writer out) throws IOException {
        StringEscapeUtil.unescapeJavaStyleString(str, out);
    }

    public static String unescapeJavaScript(String str) {
        return StringEscapeUtil.unescapeJavaStyleString(str);
    }

    public static void unescapeJavaScript(String str, Writer out) throws IOException {
        StringEscapeUtil.unescapeJavaStyleString(str, out);
    }

    private static String unescapeJavaStyleString(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter out = new StringWriter(str.length());
            if (StringEscapeUtil.unescapeJavaStyleString(str, out)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean unescapeJavaStyleString(String str, Writer out) throws IOException {
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        int length = str.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                String unicodeStr = unicode.toString();
                try {
                    int value = Integer.parseInt(unicodeStr, 16);
                    out.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    needToChange = true;
                }
                catch (NumberFormatException e) {
                    out.write("\\u" + unicodeStr);
                }
                continue;
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.write(92);
                        needToChange = true;
                        break;
                    }
                    case '\'': {
                        out.write(39);
                        needToChange = true;
                        break;
                    }
                    case '\"': {
                        out.write(34);
                        needToChange = true;
                        break;
                    }
                    case 'r': {
                        out.write(13);
                        needToChange = true;
                        break;
                    }
                    case 'f': {
                        out.write(12);
                        needToChange = true;
                        break;
                    }
                    case 't': {
                        out.write(9);
                        needToChange = true;
                        break;
                    }
                    case 'n': {
                        out.write(10);
                        needToChange = true;
                        break;
                    }
                    case 'b': {
                        out.write(8);
                        needToChange = true;
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.write(ch);
        }
        if (hadSlash) {
            out.write(92);
        }
        return needToChange;
    }

    public static String escapeHtml(String str) {
        return StringEscapeUtil.escapeEntities(Entities.HTML40, str);
    }

    public static void escapeHtml(String str, Writer out) throws IOException {
        StringEscapeUtil.escapeEntities(Entities.HTML40, str, out);
    }

    public static String escapeXml(String str) {
        return StringEscapeUtil.escapeEntities(Entities.XML, str);
    }

    public static void escapeXml(String str, Writer out) throws IOException {
        StringEscapeUtil.escapeEntities(Entities.XML, str, out);
    }

    public static String escapeEntities(Entities entities, String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter out = new StringWriter(str.length());
            if (StringEscapeUtil.escapeEntitiesInternal(entities, str, out)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    public static void escapeEntities(Entities entities, String str, Writer out) throws IOException {
        StringEscapeUtil.escapeEntitiesInternal(entities, str, out);
    }

    public static String unescapeHtml(String str) {
        return StringEscapeUtil.unescapeEntities(Entities.HTML40, str);
    }

    public static void unescapeHtml(String str, Writer out) throws IOException {
        StringEscapeUtil.unescapeEntities(Entities.HTML40, str, out);
    }

    public static String unescapeXml(String str) {
        return StringEscapeUtil.unescapeEntities(Entities.XML, str);
    }

    public static void unescapeXml(String str, Writer out) throws IOException {
        StringEscapeUtil.unescapeEntities(Entities.XML, str, out);
    }

    public static String unescapeEntities(Entities entities, String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter out = new StringWriter(str.length());
            if (StringEscapeUtil.unescapeEntitiesInternal(entities, str, out)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    public static void unescapeEntities(Entities entities, String str, Writer out) throws IOException {
        StringEscapeUtil.unescapeEntitiesInternal(entities, str, out);
    }

    private static boolean escapeEntitiesInternal(Entities entities, String str, Writer out) throws IOException {
        boolean needToChange = false;
        if (entities == null) {
            throw new IllegalArgumentException("The Entities must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entityName = entities.getEntityName(ch);
            if (entityName == null) {
                out.write(ch);
                continue;
            }
            out.write(38);
            out.write(entityName);
            out.write(59);
            needToChange = true;
        }
        return needToChange;
    }

    private static boolean unescapeEntitiesInternal(Entities entities, String str, Writer out) throws IOException {
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                int semi;
                block12: {
                    semi = str.indexOf(59, i + 1);
                    if (semi == -1 || i + 1 >= semi - 1) {
                        out.write(ch);
                        continue;
                    }
                    if (str.charAt(i + 1) == '#') {
                        if (i + 2 >= semi - 1) {
                            out.write(ch);
                            out.write(35);
                            ++i;
                            continue;
                        }
                        try {
                            int entityValue = Integer.parseInt(str.substring(i + 2, semi));
                            out.write(entityValue);
                            needToChange = true;
                            break block12;
                        }
                        catch (NumberFormatException e) {
                            out.write(ch);
                            out.write(35);
                            ++i;
                            continue;
                        }
                    }
                    String entityName = str.substring(i + 1, semi);
                    int entityValue = -1;
                    if (entities != null) {
                        entityValue = entities.getEntityValue(entityName);
                    }
                    if (entityValue == -1) {
                        out.write(38);
                        out.write(entityName);
                        out.write(59);
                    } else {
                        out.write(entityValue);
                        needToChange = true;
                    }
                }
                i = semi;
                continue;
            }
            out.write(ch);
        }
        return needToChange;
    }

    public static String escapeSql(String str) {
        return StringUtil.replace(str, "'", "''");
    }

    public static void escapeSql(String str, Writer out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        String result = StringUtil.replace(str, "'", "''");
        if (result != null) {
            out.write(result);
        }
    }

    public static String escapeURL(String str) {
        try {
            return StringEscapeUtil.escapeURLInternal(str, null, true);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String escapeURL(String str, String encoding) throws UnsupportedEncodingException {
        return StringEscapeUtil.escapeURLInternal(str, encoding, true);
    }

    public static String escapeURL(String str, String encoding, boolean strict) throws UnsupportedEncodingException {
        return StringEscapeUtil.escapeURLInternal(str, encoding, strict);
    }

    public static void escapeURL(String str, String encoding, Writer out) throws IOException {
        StringEscapeUtil.escapeURLInternal(str, encoding, out, true);
    }

    public static void escapeURL(String str, String encoding, Writer out, boolean strict) throws IOException {
        StringEscapeUtil.escapeURLInternal(str, encoding, out, strict);
    }

    private static String escapeURLInternal(String str, String encoding, boolean strict) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        try {
            StringWriter out = new StringWriter(str.length());
            if (StringEscapeUtil.escapeURLInternal(str, encoding, out, strict)) {
                return out.toString();
            }
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean escapeURLInternal(String str, String encoding, Writer out, boolean strict) throws IOException {
        if (encoding == null) {
            encoding = LocaleUtil.getContext().getCharset();
        }
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, encoding);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (StringEscapeUtil.isSafeCharacter(ch, strict)) {
                out.write(ch);
                continue;
            }
            if (ch == ' ') {
                out.write(43);
                needToChange = true;
                continue;
            }
            try {
                writer.write(ch);
                writer.flush();
            }
            catch (IOException e) {
                baos.reset();
                continue;
            }
            byte[] bytes = baos.toByteArray();
            for (int j = 0; j < bytes.length; ++j) {
                byte toEscape = bytes[j];
                out.write(37);
                int low = toEscape & 0xF;
                int high = (toEscape & 0xF0) >> 4;
                out.write(HEXADECIMAL[high]);
                out.write(HEXADECIMAL[low]);
            }
            baos.reset();
            needToChange = true;
        }
        return needToChange;
    }

    private static boolean isSafeCharacter(int ch, boolean strict) {
        if (strict) {
            return UNRESERVED.get(ch);
        }
        return ch > 32 && !RESERVED.get(ch) && !Character.isWhitespace((char)ch);
    }

    public static String unescapeURL(String str) {
        try {
            return StringEscapeUtil.unescapeURLInternal(str, null);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String unescapeURL(String str, String encoding) throws UnsupportedEncodingException {
        return StringEscapeUtil.unescapeURLInternal(str, encoding);
    }

    public static void unescapeURL(String str, String encoding, Writer out) throws IOException {
        StringEscapeUtil.unescapeURLInternal(str, encoding, out);
    }

    private static String unescapeURLInternal(String str, String encoding) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        try {
            StringWriter out = new StringWriter(str.length());
            if (StringEscapeUtil.unescapeURLInternal(str, encoding, out)) {
                return out.toString();
            }
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean unescapeURLInternal(String str, String encoding, Writer out) throws IOException {
        if (encoding == null) {
            encoding = LocaleUtil.getContext().getCharset();
        }
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        int length = str.length();
        byte[] buffer = null;
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0100') {
                if (buffer == null) {
                    buffer = new byte[length - i];
                }
                switch (ch) {
                    case '+': {
                        buffer[pos++] = 32;
                        needToChange = true;
                        break;
                    }
                    case '%': {
                        if (i + 2 < length) {
                            try {
                                buffer[pos] = (byte)Integer.parseInt(str.substring(i + 1, i + 3), 16);
                                ++pos;
                                i += 2;
                                needToChange = true;
                            }
                            catch (NumberFormatException e) {
                                buffer[pos++] = (byte)ch;
                            }
                            break;
                        }
                        buffer[pos++] = (byte)ch;
                        break;
                    }
                    default: {
                        buffer[pos++] = (byte)ch;
                        break;
                    }
                }
                continue;
            }
            if (pos > 0) {
                out.write(new String(buffer, 0, pos, encoding));
                pos = 0;
            }
            out.write(ch);
        }
        if (pos > 0) {
            out.write(new String(buffer, 0, pos, encoding));
            pos = 0;
        }
        return needToChange;
    }

    static {
        int i;
        ALPHA = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            ALPHA.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALPHA.set(i);
        }
        ALPHANUM = new BitSet(256);
        ALPHANUM.or(ALPHA);
        for (i = 48; i <= 57; ++i) {
            ALPHANUM.set(i);
        }
        MARK = new BitSet(256);
        MARK.set(45);
        MARK.set(95);
        MARK.set(46);
        MARK.set(33);
        MARK.set(126);
        MARK.set(42);
        MARK.set(39);
        MARK.set(40);
        MARK.set(41);
        RESERVED = new BitSet(256);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        UNRESERVED = new BitSet(256);
        UNRESERVED.or(ALPHANUM);
        UNRESERVED.or(MARK);
        HEXADECIMAL = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    }
}

