/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.common.lang.diagnostic;

import com.alibaba.common.lang.ClassLoaderUtil;
import com.alibaba.common.lang.ClassUtil;
import com.alibaba.common.lang.ObjectUtil;

public class ClassView {
    public static String toString(Class clazz) {
        if (clazz.isPrimitive()) {
            return ClassUtil.getClassName(clazz);
        }
        if (clazz.isArray()) {
            return "Array " + ClassUtil.getClassName(clazz) + "\n" + ClassView.toString(ClassUtil.getArrayComponentType(clazz));
        }
        if (clazz.isInterface()) {
            return ClassView.toInterfaceString(clazz, "");
        }
        return ClassView.toClassString(clazz, "");
    }

    private static String toInterfaceString(Class clazz, String indent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent).append("Interface ").append(clazz.getName()).append("  (").append(ClassView.toClassString(clazz)).append(')');
        Class<?>[] interfaceClass = clazz.getInterfaces();
        int c = interfaceClass.length;
        for (int i = 0; i < c; ++i) {
            clazz = interfaceClass[i];
            buffer.append('\n').append(ClassView.toInterfaceString(clazz, indent + "  "));
        }
        return buffer.toString();
    }

    private static String toClassString(Class clazz, String indent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent).append("Class ").append(clazz.getName()).append("  (").append(ClassView.toClassString(clazz)).append(')');
        indent = indent + "  ";
        Class<?>[] interfaceClass = clazz.getInterfaces();
        int c = interfaceClass.length;
        for (int i = 0; i < c; ++i) {
            buffer.append('\n').append(ClassView.toInterfaceString(interfaceClass[i], indent));
        }
        if ((clazz = clazz.getSuperclass()) != null) {
            buffer.append('\n').append(ClassView.toClassString(clazz, indent));
        }
        return buffer.toString();
    }

    private static String toClassString(Class clz) {
        ClassLoader loader = clz.getClassLoader();
        return "loaded by " + ObjectUtil.identityToString(loader, "System ClassLoader") + ", " + ClassLoaderUtil.whichClass(clz.getName());
    }

    public static void main(String[] args) throws ClassNotFoundException {
        if (args.length == 0) {
            System.out.println("\nUsage:");
            System.out.println("    java " + ClassView.class.getName() + " MyClass");
            System.out.println("    java " + ClassView.class.getName() + " my.package.MyClass");
            System.out.println("    java " + ClassView.class.getName() + " META-INF/MANIFEST.MF");
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            System.out.println(ClassView.toString(ClassLoaderUtil.loadClass(args[i])));
        }
    }
}

