/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.common.lang.diagnostic;

import com.alibaba.common.lang.ObjectUtil;
import com.alibaba.common.lang.StringUtil;
import com.alibaba.common.lang.enumeration.IntegerEnum;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Profiler {
    private static final ThreadLocal entryStack = new ThreadLocal();

    public static void start() {
        Profiler.start((String)null);
    }

    public static void start(String message) {
        entryStack.set(new Entry(message, null, null));
    }

    public static void start(Message message) {
        entryStack.set(new Entry(message, null, null));
    }

    public static void reset() {
        entryStack.set(null);
    }

    public static void enter(String message) {
        Entry currentEntry = Profiler.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.enterSubEntry(message);
        }
    }

    public static void enter(Message message) {
        Entry currentEntry = Profiler.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.enterSubEntry(message);
        }
    }

    public static void release() {
        Entry currentEntry = Profiler.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.release();
        }
    }

    public static long getDuration() {
        Entry entry = (Entry)entryStack.get();
        if (entry != null) {
            return entry.getDuration();
        }
        return -1L;
    }

    public static String dump() {
        return Profiler.dump("", "");
    }

    public static String dump(String prefix) {
        return Profiler.dump(prefix, prefix);
    }

    public static String dump(String prefix1, String prefix2) {
        Entry entry = (Entry)entryStack.get();
        if (entry != null) {
            return entry.toString(prefix1, prefix2);
        }
        return "";
    }

    public static Entry getEntry() {
        return (Entry)entryStack.get();
    }

    private static Entry getCurrentEntry() {
        Entry subEntry = (Entry)entryStack.get();
        Entry entry = null;
        if (subEntry != null) {
            while ((subEntry = (entry = subEntry).getUnreleasedEntry()) != null) {
            }
        }
        return entry;
    }

    public static interface Message {
        public MessageLevel getMessageLevel(Entry var1);

        public String getBriefMessage();

        public String getDetailedMessage();
    }

    public static final class MessageLevel
    extends IntegerEnum {
        private static final long serialVersionUID = 3257849896026388537L;
        public static final MessageLevel NO_MESSAGE = (MessageLevel)MessageLevel.create();
        public static final MessageLevel BRIEF_MESSAGE = (MessageLevel)MessageLevel.create();
        public static final MessageLevel DETAILED_MESSAGE = (MessageLevel)MessageLevel.create();
    }

    public static final class Entry {
        private final List subEntries = new ArrayList(4);
        private final Object message;
        private final Entry parentEntry;
        private final Entry firstEntry;
        private final long baseTime;
        private final long startTime;
        private long endTime;

        private Entry(Object message, Entry parentEntry, Entry firstEntry) {
            this.message = message;
            this.startTime = System.currentTimeMillis();
            this.parentEntry = parentEntry;
            this.firstEntry = (Entry)ObjectUtil.defaultIfNull(firstEntry, this);
            this.baseTime = firstEntry == null ? 0L : firstEntry.startTime;
        }

        public String getMessage() {
            String messageString = null;
            if (this.message instanceof String) {
                messageString = (String)this.message;
            } else if (this.message instanceof Message) {
                Message messageObject = (Message)this.message;
                MessageLevel level = MessageLevel.BRIEF_MESSAGE;
                if (this.isReleased()) {
                    level = messageObject.getMessageLevel(this);
                }
                messageString = level == MessageLevel.DETAILED_MESSAGE ? messageObject.getDetailedMessage() : messageObject.getBriefMessage();
            }
            return StringUtil.defaultIfEmpty(messageString, null);
        }

        public long getStartTime() {
            return this.baseTime > 0L ? this.startTime - this.baseTime : 0L;
        }

        public long getEndTime() {
            if (this.endTime < this.baseTime) {
                return -1L;
            }
            return this.endTime - this.baseTime;
        }

        public long getDuration() {
            if (this.endTime < this.startTime) {
                return -1L;
            }
            return this.endTime - this.startTime;
        }

        public long getDurationOfSelf() {
            long duration = this.getDuration();
            if (duration < 0L) {
                return -1L;
            }
            if (this.subEntries.isEmpty()) {
                return duration;
            }
            for (int i = 0; i < this.subEntries.size(); ++i) {
                Entry subEntry = (Entry)this.subEntries.get(i);
                duration -= subEntry.getDuration();
            }
            if (duration < 0L) {
                return -1L;
            }
            return duration;
        }

        public double getPecentage() {
            double parentDuration = 0.0;
            double duration = this.getDuration();
            if (this.parentEntry != null && this.parentEntry.isReleased()) {
                parentDuration = this.parentEntry.getDuration();
            }
            if (duration > 0.0 && parentDuration > 0.0) {
                return duration / parentDuration;
            }
            return 0.0;
        }

        public double getPecentageOfAll() {
            double firstDuration = 0.0;
            double duration = this.getDuration();
            if (this.firstEntry != null && this.firstEntry.isReleased()) {
                firstDuration = this.firstEntry.getDuration();
            }
            if (duration > 0.0 && firstDuration > 0.0) {
                return duration / firstDuration;
            }
            return 0.0;
        }

        public List getSubEntries() {
            return Collections.unmodifiableList(this.subEntries);
        }

        private void release() {
            this.endTime = System.currentTimeMillis();
        }

        private boolean isReleased() {
            return this.endTime > 0L;
        }

        private void enterSubEntry(Object message) {
            Entry subEntry = new Entry(message, this, this.firstEntry);
            this.subEntries.add(subEntry);
        }

        private Entry getUnreleasedEntry() {
            Entry subEntry = null;
            if (!this.subEntries.isEmpty() && (subEntry = (Entry)this.subEntries.get(this.subEntries.size() - 1)).isReleased()) {
                subEntry = null;
            }
            return subEntry;
        }

        public String toString() {
            return this.toString("", "");
        }

        private String toString(String prefix1, String prefix2) {
            StringBuffer buffer = new StringBuffer();
            this.toString(buffer, prefix1, prefix2);
            return buffer.toString();
        }

        private void toString(StringBuffer buffer, String prefix1, String prefix2) {
            buffer.append(prefix1);
            String message = this.getMessage();
            long startTime = this.getStartTime();
            long duration = this.getDuration();
            long durationOfSelf = this.getDurationOfSelf();
            double percent = this.getPecentage();
            double percentOfAll = this.getPecentageOfAll();
            Object[] params = new Object[]{message, new Long(startTime), new Long(duration), new Long(durationOfSelf), new Double(percent), new Double(percentOfAll)};
            StringBuffer pattern = new StringBuffer("{1,number} ");
            if (this.isReleased()) {
                pattern.append("[{2,number}ms");
                if (durationOfSelf > 0L && durationOfSelf != duration) {
                    pattern.append(" ({3,number}ms)");
                }
                if (percent > 0.0) {
                    pattern.append(", {4,number,##%}");
                }
                if (percentOfAll > 0.0) {
                    pattern.append(", {5,number,##%}");
                }
                pattern.append("]");
            } else {
                pattern.append("[UNRELEASED]");
            }
            if (message != null) {
                pattern.append(" - {0}");
            }
            buffer.append(MessageFormat.format(pattern.toString(), params));
            for (int i = 0; i < this.subEntries.size(); ++i) {
                Entry subEntry = (Entry)this.subEntries.get(i);
                buffer.append('\n');
                if (i == this.subEntries.size() - 1) {
                    subEntry.toString(buffer, prefix2 + "`---", prefix2 + "    ");
                    continue;
                }
                if (i == 0) {
                    subEntry.toString(buffer, prefix2 + "+---", prefix2 + "|   ");
                    continue;
                }
                subEntry.toString(buffer, prefix2 + "+---", prefix2 + "|   ");
            }
        }
    }
}

