/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.common.lang.enumeration;

import com.alibaba.common.lang.ClassLoaderUtil;
import com.alibaba.common.lang.StringUtil;
import com.alibaba.common.lang.enumeration.CreateEnumException;
import com.alibaba.common.lang.enumeration.EnumUtil;
import com.alibaba.common.lang.enumeration.Flags;
import com.alibaba.common.lang.enumeration.internal.NumberType;
import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Enum
extends Number
implements NumberType,
Comparable,
Serializable {
    private static final long serialVersionUID = -3420208858441821772L;
    private String name;
    private Number value;

    protected Enum() {
    }

    protected static final Enum create() {
        return Enum.createEnum(null, null, false);
    }

    protected static final Enum create(String name) {
        return Enum.createEnum(name, null, false);
    }

    static final Enum createEnum(Number value) {
        return Enum.createEnum(null, value, true);
    }

    static final Enum createEnum(String name, Number value) {
        return Enum.createEnum(name, value, true);
    }

    private static Enum createEnum(String name, Number value, boolean withValue) {
        Enum enumObject;
        Class enumClass;
        String enumClassName = null;
        try {
            enumClassName = Enum.getCallerClassName();
            enumClass = ClassLoaderUtil.loadClass(enumClassName);
            enumObject = (Enum)enumClass.newInstance();
            enumObject.setName(StringUtil.trimToNull(name));
        }
        catch (ClassNotFoundException e) {
            throw new CreateEnumException("Could not find enum class " + enumClassName, e);
        }
        catch (Exception e) {
            throw new CreateEnumException("Could not instantiate enum instance of class " + enumClassName, e);
        }
        if (withValue && value == null) {
            throw new NullPointerException("The Enum value must not be null");
        }
        EnumType enumType = EnumUtil.getEnumType(enumClass);
        boolean flagMode = enumObject instanceof Flags;
        enumObject.value = withValue ? (Number)enumType.setValue(value, flagMode) : (Number)enumType.getNextValue(flagMode);
        enumType.enumList.add(enumObject);
        if (!enumType.valueMap.containsKey(enumObject.value)) {
            enumType.valueMap.put(enumObject.value, enumObject);
        }
        if (enumObject.name != null && !enumType.nameMap.containsKey(enumObject.name)) {
            enumType.nameMap.put(enumObject.name, enumObject);
        }
        return enumObject;
    }

    private static String getCallerClassName() {
        StackTraceElement[] callers = new Throwable().getStackTrace();
        String enumClass = Enum.class.getName();
        for (int i = 0; i < callers.length; ++i) {
            StackTraceElement caller = callers[i];
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            if (enumClass.equals(className) || !"<clinit>".equals(methodName)) continue;
            return className;
        }
        throw new CreateEnumException("Cannot get Enum-class name");
    }

    public String getName() {
        if (this.name == null) {
            Class enumClass = this.ensureClassLoaded();
            EnumType enumType = EnumUtil.getEnumType(enumClass);
            enumType.populateNames(enumClass);
        }
        return this.name;
    }

    private Enum setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("Enum name already set: " + this.name);
        }
        this.name = name;
        return this;
    }

    public Number getValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public short shortValue() {
        return (short)this.intValue();
    }

    public int compareTo(Object otherEnum) {
        if (!this.getClass().equals(otherEnum.getClass())) {
            throw new CreateEnumException(MessageFormat.format("Could not compare object of \"{0}\" with object of \"{1}\"", this.getClass().getName(), otherEnum.getClass().getName()));
        }
        return ((Comparable)((Object)this.value)).compareTo(((Enum)otherEnum).value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.value.equals(((Enum)obj).value);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class ensureClassLoaded() {
        Class<?> enumClass;
        Class<?> clazz = enumClass = this.getClass();
        synchronized (clazz) {
            return enumClass;
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.getName();
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        Class enumClass = this.ensureClassLoaded();
        EnumType enumType = EnumUtil.getEnumType(enumClass);
        Enum enumObject = (Enum)enumType.nameMap.get(this.getName());
        if (enumObject == null) {
            enumType.populateNames(enumClass);
            enumObject = (Enum)enumType.nameMap.get(this.getName());
        }
        if (enumObject == null) {
            throw new InvalidClassException("Enum name \"" + this.getName() + "\" not found in class " + enumClass.getName());
        }
        if (!enumObject.value.equals(this.value)) {
            throw new InvalidClassException("Enum value \"" + this.value + "\" does not match in class " + enumClass.getName());
        }
        return enumObject;
    }

    protected static abstract class EnumType {
        private Number value;
        final Map nameMap = Collections.synchronizedMap(new HashMap());
        final Map valueMap = Collections.synchronizedMap(new HashMap());
        final List enumList = new ArrayList();

        protected EnumType() {
        }

        final Number setValue(Number value, boolean flagMode) {
            this.value = value;
            return value;
        }

        final Number getNextValue(boolean flagMode) {
            this.value = this.getNextValue(this.value, flagMode);
            if (flagMode && this.isZero(this.value)) {
                throw new UnsupportedOperationException("The flag value is out of range");
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void populateNames(Class enumClass) {
            Class clazz = enumClass;
            synchronized (clazz) {
                Field[] fields = enumClass.getFields();
                block5: for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    int modifier = field.getModifiers();
                    if (!Modifier.isPublic(modifier) || !Modifier.isFinal(modifier) || !Modifier.isStatic(modifier)) continue;
                    try {
                        Object value = field.get(null);
                        Iterator j = this.valueMap.values().iterator();
                        while (j.hasNext()) {
                            Enum enumObject = (Enum)j.next();
                            if (value != enumObject || enumObject.name != null) continue;
                            enumObject.name = field.getName();
                            this.nameMap.put(enumObject.name, enumObject);
                            continue block5;
                        }
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new CreateEnumException(e);
                    }
                }
            }
        }

        protected abstract Class getUnderlyingClass();

        protected abstract Number getNextValue(Number var1, boolean var2);

        protected abstract boolean isZero(Number var1);
    }
}

