/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.common.lang.enumeration;

import com.alibaba.common.lang.enumeration.Enum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class EnumUtil {
    private static final Map entries = new WeakHashMap();

    public static Class getUnderlyingClass(Class enumClass) {
        return EnumUtil.getEnumType(enumClass).getUnderlyingClass();
    }

    public static boolean isNameDefined(Class enumClass, String name) {
        return EnumUtil.getEnumType((Class)enumClass).nameMap.containsKey(name);
    }

    public static boolean isValueDefined(Class enumClass, Number value) {
        return EnumUtil.getEnumType((Class)enumClass).valueMap.containsKey(value);
    }

    public static Enum getEnumByName(Class enumClass, String name) {
        Enum.EnumType enumType = EnumUtil.getEnumType(enumClass);
        if (enumType.enumList.size() != enumType.nameMap.size()) {
            enumType.populateNames(enumClass);
        }
        return (Enum)enumType.nameMap.get(name);
    }

    public static Enum getEnumByValue(Class enumClass, Number value) {
        return (Enum)EnumUtil.getEnumType((Class)enumClass).valueMap.get(value);
    }

    public static Enum getEnumByValue(Class enumClass, int value) {
        return (Enum)EnumUtil.getEnumType((Class)enumClass).valueMap.get(new Integer(value));
    }

    public static Enum getEnumByValue(Class enumClass, long value) {
        return (Enum)EnumUtil.getEnumType((Class)enumClass).valueMap.get(new Long(value));
    }

    public static Map getEnumMap(Class enumClass) {
        return Collections.unmodifiableMap(EnumUtil.getEnumType((Class)enumClass).nameMap);
    }

    public static Iterator getEnumIterator(Class enumClass) {
        return EnumUtil.getEnumType((Class)enumClass).enumList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getEnumEntryMap(Class enumClass) {
        ClassLoader classLoader = enumClass.getClassLoader();
        ConcurrentHashMap entryMap = null;
        Map map = entries;
        synchronized (map) {
            entryMap = (ConcurrentHashMap)entries.get(classLoader);
            if (entryMap == null) {
                entryMap = new ConcurrentHashMap();
                entries.put(classLoader, entryMap);
            }
        }
        return entryMap;
    }

    static Enum.EnumType getEnumType(Class enumClass) {
        if (enumClass == null) {
            throw new NullPointerException("The Enum class must not be null");
        }
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException(MessageFormat.format("Class \"{0}\" is not a subclass of Enum", enumClass.getName()));
        }
        ConcurrentHashMap entryMap = (ConcurrentHashMap)EnumUtil.getEnumEntryMap(enumClass);
        Enum.EnumType enumType = (Enum.EnumType)entryMap.get(enumClass.getName());
        if (enumType == null) {
            Method createEnumTypeMethod = EnumUtil.findStaticMethod(enumClass, "createEnumType", new Class[0]);
            if (createEnumTypeMethod != null) {
                try {
                    enumType = (Enum.EnumType)createEnumTypeMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (enumType != null) {
                Enum.EnumType existing = entryMap.putIfAbsent(enumClass.getName(), enumType);
                if (existing != null) {
                    enumType = existing;
                }
                enumType.populateNames(enumClass);
            }
        }
        if (enumType == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Could not create EnumType for class \"{0}\"", enumClass.getName()));
        }
        return enumType;
    }

    private static Method findStaticMethod(Class enumClass, String methodName, Class[] paramTypes) {
        Method method = null;
        Class clazz = enumClass;
        while (!clazz.equals(Enum.class)) {
            try {
                method = clazz.getDeclaredMethod(methodName, paramTypes);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        if (method != null && Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        return null;
    }
}

