/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.common.lang.i18n;

import com.alibaba.common.lang.StringUtil;
import com.alibaba.common.lang.i18n.LocaleInfo;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class LocaleUtil {
    private static final Set AVAILABLE_LANGUAGES = new HashSet();
    private static final Set AVAILABLE_COUNTRIES = new HashSet();
    private static final LocaleInfo systemLocaleInfo;
    private static LocaleInfo defaultLocalInfo;
    private static final ThreadLocal contextLocaleInfoHolder;

    public static Locale parseLocale(String localeName) {
        String[] localeParts;
        int len;
        if (localeName != null && (len = (localeParts = StringUtil.split(localeName, "_")).length) > 0) {
            String language = localeParts[0];
            String country = "";
            String variant = "";
            if (len > 1) {
                country = localeParts[1];
            }
            if (len > 2) {
                variant = localeParts[2];
            }
            return new Locale(language, country, variant);
        }
        return null;
    }

    public static LocaleInfo parseLocaleInfo(String localeName) {
        Locale locale = null;
        String charset = null;
        if (StringUtil.isNotEmpty(localeName)) {
            int index = localeName.indexOf(":");
            String localePart = localeName;
            String charsetPart = null;
            if (index >= 0) {
                localePart = localeName.substring(0, index);
                charsetPart = localeName.substring(index + 1);
            }
            locale = LocaleUtil.parseLocale(localePart);
            charset = StringUtil.trimToNull(charsetPart);
        }
        return new LocaleInfo(locale, charset);
    }

    public static boolean isLocaleSupported(Locale locale) {
        return locale != null && AVAILABLE_LANGUAGES.contains(locale.getLanguage()) && AVAILABLE_COUNTRIES.contains(locale.getCountry());
    }

    public static boolean isCharsetSupported(String charset) {
        return Charset.isSupported(charset);
    }

    public static String getCanonicalCharset(String charset) {
        return Charset.forName(charset).name();
    }

    public static String getCanonicalCharset(String charset, String defaultCharset) {
        String result;
        block4: {
            result = null;
            try {
                result = LocaleUtil.getCanonicalCharset(charset);
            }
            catch (IllegalArgumentException e) {
                if (defaultCharset == null) break block4;
                try {
                    result = LocaleUtil.getCanonicalCharset(defaultCharset);
                }
                catch (IllegalArgumentException ee) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static List calculateBundleNames(String baseName, Locale locale) {
        return LocaleUtil.calculateBundleNames(baseName, locale, false);
    }

    public static List calculateBundleNames(String baseName, Locale locale, boolean noext) {
        int extIndex;
        baseName = StringUtil.defaultIfEmpty(baseName);
        if (locale == null) {
            locale = new Locale("");
        }
        String ext = "";
        int extLength = 0;
        if (!noext && (extIndex = baseName.lastIndexOf(".")) != -1) {
            ext = baseName.substring(extIndex, baseName.length());
            extLength = ext.length();
            baseName = baseName.substring(0, extIndex);
            if (extLength == 1) {
                ext = "";
                extLength = 0;
            }
        }
        ArrayList<String> result = new ArrayList<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        StringBuffer buffer = new StringBuffer(baseName);
        buffer.append(ext);
        result.add(buffer.toString());
        buffer.setLength(buffer.length() - extLength);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        if (buffer.length() > 0) {
            buffer.append('_');
        }
        buffer.append(language);
        if (languageLength > 0) {
            buffer.append(ext);
            result.add(buffer.toString());
            buffer.setLength(buffer.length() - extLength);
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        buffer.append('_').append(country);
        if (countryLength > 0) {
            buffer.append(ext);
            result.add(buffer.toString());
            buffer.setLength(buffer.length() - extLength);
        }
        if (variantLength == 0) {
            return result;
        }
        buffer.append('_').append(variant);
        buffer.append(ext);
        result.add(buffer.toString());
        buffer.setLength(buffer.length() - extLength);
        return result;
    }

    public static LocaleInfo getSystem() {
        return systemLocaleInfo;
    }

    public static LocaleInfo getDefault() {
        return defaultLocalInfo == null ? systemLocaleInfo : defaultLocalInfo;
    }

    public static LocaleInfo setDefault(Locale locale) {
        LocaleInfo old = LocaleUtil.getDefault();
        defaultLocalInfo = new LocaleInfo(locale, null, systemLocaleInfo);
        return old;
    }

    public static LocaleInfo setDefault(Locale locale, String charset) {
        LocaleInfo old = LocaleUtil.getDefault();
        defaultLocalInfo = new LocaleInfo(locale, charset, systemLocaleInfo);
        return old;
    }

    public static LocaleInfo setDefault(LocaleInfo localeInfo) {
        if (localeInfo == null) {
            return LocaleUtil.setDefault(null, null);
        }
        LocaleInfo old = LocaleUtil.getDefault();
        defaultLocalInfo = localeInfo;
        return old;
    }

    public static void resetDefault() {
        defaultLocalInfo = systemLocaleInfo;
    }

    public static LocaleInfo getContext() {
        LocaleInfo contextLocaleInfo = (LocaleInfo)contextLocaleInfoHolder.get();
        return contextLocaleInfo == null ? LocaleUtil.getDefault() : contextLocaleInfo;
    }

    public static LocaleInfo setContext(Locale locale) {
        LocaleInfo old = LocaleUtil.getContext();
        contextLocaleInfoHolder.set(new LocaleInfo(locale, null, defaultLocalInfo));
        return old;
    }

    public static LocaleInfo setContext(Locale locale, String charset) {
        LocaleInfo old = LocaleUtil.getContext();
        contextLocaleInfoHolder.set(new LocaleInfo(locale, charset, defaultLocalInfo));
        return old;
    }

    public static LocaleInfo setContext(LocaleInfo localeInfo) {
        if (localeInfo == null) {
            return LocaleUtil.setContext(null, null);
        }
        LocaleInfo old = LocaleUtil.getContext();
        contextLocaleInfoHolder.set(localeInfo);
        return old;
    }

    public static void resetContext() {
        contextLocaleInfoHolder.set(null);
    }

    static {
        contextLocaleInfoHolder = new ThreadLocal();
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (int i = 0; i < availableLocales.length; ++i) {
            Locale locale = availableLocales[i];
            AVAILABLE_LANGUAGES.add(locale.getLanguage());
            AVAILABLE_COUNTRIES.add(locale.getCountry());
        }
        defaultLocalInfo = systemLocaleInfo = new LocaleInfo();
    }
}

