/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.configuration;

import com.alipay.sofa.healthcheck.core.AfterReadinessCheckCallbackProcessor;
import com.alipay.sofa.healthcheck.core.HealthCheckerProcessor;
import com.alipay.sofa.healthcheck.core.HealthIndicatorProcessor;
import com.alipay.sofa.healthcheck.service.ReadinessEndpointWebExtension;
import com.alipay.sofa.healthcheck.service.SofaBootHealthIndicator;
import com.alipay.sofa.healthcheck.service.SofaBootReadinessCheckEndpoint;
import com.alipay.sofa.healthcheck.startup.ReadinessCheckListener;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorProperties;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SofaBootHealthCheckAutoConfiguration {
    @Bean
    public ReadinessCheckListener readinessCheckListener() {
        return new ReadinessCheckListener();
    }

    @Bean
    public HealthCheckerProcessor healthCheckerProcessor() {
        return new HealthCheckerProcessor();
    }

    @Bean
    public HealthIndicatorProcessor healthIndicatorProcessor() {
        return new HealthIndicatorProcessor();
    }

    @Bean
    public AfterReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor() {
        return new AfterReadinessCheckCallbackProcessor();
    }

    @Bean
    public SofaBootHealthIndicator sofaBootHealthIndicator() {
        return new SofaBootHealthIndicator();
    }

    @ConditionalOnClass(value={Endpoint.class})
    @AutoConfigureBefore(name={"org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration"})
    public static class ReadinessCheckExtensionConfiguration {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        public ReadinessEndpointWebExtension readinessEndpointWebExtension() {
            return new ReadinessEndpointWebExtension();
        }

        @Bean
        @ConditionalOnMissingBean
        public HealthStatusHttpMapper createHealthStatusHttpMapper(HealthIndicatorProperties healthIndicatorProperties) {
            HealthStatusHttpMapper statusHttpMapper = new HealthStatusHttpMapper();
            if (healthIndicatorProperties.getHttpMapping() != null) {
                statusHttpMapper.addStatusMapping(healthIndicatorProperties.getHttpMapping());
            }
            statusHttpMapper.addStatusMapping(Status.UNKNOWN, Integer.valueOf(500));
            return statusHttpMapper;
        }
    }

    @ConditionalOnClass(value={Endpoint.class})
    public static class ConditionReadinessEndpointConfiguration {
        @Bean
        @ConditionalOnEnabledEndpoint
        public SofaBootReadinessCheckEndpoint sofaBootReadinessCheckEndpoint() {
            return new SofaBootReadinessCheckEndpoint();
        }
    }
}

