/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.healthcheck.core;

import com.alipay.sofa.healthcheck.log.SofaBootHealthCheckLoggerFactory;
import com.alipay.sofa.healthcheck.service.SofaBootHealthIndicator;
import com.alipay.sofa.healthcheck.utils.HealthCheckUtils;
import com.alipay.sofa.infra.utils.BinaryOperators;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HealthIndicatorProcessor {
    private static Logger logger = SofaBootHealthCheckLoggerFactory.getLogger(HealthIndicatorProcessor.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private AtomicBoolean isInitiated = new AtomicBoolean(false);
    private LinkedHashMap<String, HealthIndicator> healthIndicators = null;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String REACTOR_CLASS = "reactor.core.publisher.Mono";

    public void init() {
        if (this.isInitiated.compareAndSet(false, true)) {
            Assert.notNull((Object)this.applicationContext, () -> "Application must not be null");
            Map beansOfType = this.applicationContext.getBeansOfType(HealthIndicator.class);
            if (ClassUtils.isPresent((String)REACTOR_CLASS, null)) {
                this.applicationContext.getBeansOfType(ReactiveHealthIndicator.class).forEach((name, indicator) -> beansOfType.put(name, () -> (Health)indicator.health().block()));
            }
            this.healthIndicators = HealthCheckUtils.sortMapAccordingToValue(beansOfType, (BeanFactory)this.applicationContext.getAutowireCapableBeanFactory());
            StringBuilder healthIndicatorInfo = new StringBuilder(512).append("Found ").append(this.healthIndicators.size()).append(" HealthIndicator implementation:").append(String.join((CharSequence)",", this.healthIndicators.keySet()));
            logger.info(healthIndicatorInfo.toString());
        }
    }

    public boolean readinessHealthCheck(Map<String, Health> healthMap) {
        Assert.notNull(this.healthIndicators, () -> "HealthIndicators must not be null.");
        logger.info("Begin SOFABoot HealthIndicator readiness check.");
        boolean result = this.healthIndicators.entrySet().stream().filter(entry -> !(entry.getValue() instanceof SofaBootHealthIndicator)).map(entry -> this.doHealthCheck((String)entry.getKey(), (HealthIndicator)entry.getValue(), healthMap)).reduce(true, BinaryOperators.andBoolean());
        if (result) {
            logger.info("SOFABoot HealthIndicator readiness check result: success.");
        } else {
            logger.error("SOFABoot HealthIndicator readiness check result: failed.");
        }
        return result;
    }

    public boolean doHealthCheck(String beanId, HealthIndicator healthIndicator, Map<String, Health> healthMap) {
        boolean result;
        Assert.notNull(healthMap, () -> "HealthMap must not be null");
        try {
            Health health = healthIndicator.health();
            Status status = health.getStatus();
            result = status.equals((Object)Status.UP);
            if (result) {
                logger.info("HealthIndicator[{}] readiness check success.", (Object)beanId);
            } else {
                logger.error("HealthIndicator[{}] readiness check fail; the status is: {}; the detail is: {}.", new Object[]{beanId, status, this.objectMapper.writeValueAsString((Object)health.getDetails())});
            }
            healthMap.put(this.getKey(beanId), health);
        }
        catch (Exception e) {
            result = false;
            logger.error(String.format("Error occurred while doing HealthIndicator[%s] readiness check.", healthIndicator.getClass()), (Throwable)e);
        }
        return result;
    }

    public String getKey(String name) {
        int index = name.toLowerCase().indexOf("healthindicator");
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }
}

