/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.io;

import com.alipay.hessian.generic.model.GenericObject;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.hessian.io.Hessian2Output;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class GenericObjectSerializer
extends AbstractSerializer {
    private static final Logger LOGGER = Logger.getLogger(GenericObjectSerializer.class.getName());
    private static final GenericObjectSerializer INSTANCE = new GenericObjectSerializer();
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private static boolean WRITE_DEFINITION_EVERYTIME = Boolean.parseBoolean(System.getProperty("generic_hessian_write_definition_everytime", "false"));
    private static final int HESSIAN2_OUTPUT_BUFFER_SIZE = 1024;
    private static Field offsetField;
    private static Field classRefsField;
    private static Field bufferField;

    public static GenericObjectSerializer getInstance() {
        return INSTANCE;
    }

    private GenericObjectSerializer() {
    }

    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (!(obj instanceof GenericObject)) {
            throw new RuntimeException("the object must be a generic object");
        }
        this.doWriteObject((GenericObject)obj, out);
    }

    public void doWriteObject(GenericObject obj, AbstractHessianOutput out) throws IOException {
        try {
            ObjectDefinition definition = this.getDefinition(obj);
            if (out.addRef(obj)) {
                return;
            }
            if (!WRITE_DEFINITION_EVERYTIME) {
                int ref = out.writeObjectBegin(obj.getType());
                if (ref == -1) {
                    this.writeDefinition(definition, out);
                    out.writeObjectBegin(obj.getType());
                }
                this.writeInstance(obj, definition, out);
            } else {
                Hessian2Output output = (Hessian2Output)out;
                HashMap<String, Integer> _classRefs = (HashMap<String, Integer>)classRefsField.get(output);
                if (_classRefs == null) {
                    _classRefs = new HashMap<String, Integer>();
                    classRefsField.set(output, _classRefs);
                }
                int ref = _classRefs.size();
                _classRefs.put("" + COUNT.incrementAndGet(), new Integer(ref));
                int _offset = (Integer)offsetField.get(output);
                if (1024 < _offset + 32) {
                    output.flush();
                    _offset = 0;
                }
                byte[] _buffer = (byte[])bufferField.get(output);
                _buffer[_offset++] = 79;
                offsetField.set(output, _offset);
                int len = obj.getType().length();
                out.writeInt(len);
                output.printString(obj.getType(), 0, len);
                this.writeDefinition(definition, out);
                _offset = (Integer)offsetField.get(output);
                if (1024 < _offset + 32) {
                    output.flush();
                    _offset = 0;
                }
                _buffer[_offset++] = 111;
                offsetField.set(output, _offset);
                output.writeInt(ref);
                this.writeInstance(obj, definition, out);
            }
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private ObjectDefinition getDefinition(GenericObject obj) {
        Set<String> fieldNames = obj.getFieldNames();
        String[] _fieldNames = new String[fieldNames.size()];
        fieldNames.toArray(_fieldNames);
        return new ObjectDefinition(obj.getType(), _fieldNames);
    }

    private void writeDefinition(ObjectDefinition definition, AbstractHessianOutput out) throws IOException {
        String[] _fieldNames = definition.getFieldNames();
        out.writeClassFieldLength(_fieldNames.length);
        for (int i = 0; i < _fieldNames.length; ++i) {
            String fieldName = _fieldNames[i];
            out.writeString(fieldName);
        }
    }

    private void writeInstance(GenericObject obj, ObjectDefinition definition, AbstractHessianOutput out) throws IOException {
        int i;
        String[] _fieldNames = definition.getFieldNames();
        FieldSerializer[] _fieldSerializers = new FieldSerializer[_fieldNames.length];
        for (i = 0; i < _fieldNames.length; ++i) {
            Object field = obj.getField(_fieldNames[i]);
            Class<?> fieldType = field == null ? null : field.getClass();
            _fieldSerializers[i] = GenericObjectSerializer.getFieldSerializer(fieldType);
        }
        for (i = 0; i < _fieldNames.length; ++i) {
            String fieldName = _fieldNames[i];
            _fieldSerializers[i].serialize(out, obj, fieldName);
        }
    }

    private static FieldSerializer getFieldSerializer(Class type) {
        if (type == null) {
            return FieldSerializer.SER;
        }
        if (Integer.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.class.equals((Object)type) || Byte.class.equals((Object)type) || Short.class.equals((Object)type)) {
            return IntFieldSerializer.SER;
        }
        if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
            return LongFieldSerializer.SER;
        }
        if (Double.TYPE.equals(type) || Float.TYPE.equals(type) || Double.class.equals((Object)type) || Float.class.equals((Object)type)) {
            return DoubleFieldSerializer.SER;
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
            return BooleanFieldSerializer.SER;
        }
        if (String.class.equals((Object)type)) {
            return StringFieldSerializer.SER;
        }
        return FieldSerializer.SER;
    }

    static {
        try {
            offsetField = Hessian2Output.class.getDeclaredField("_offset");
            offsetField.setAccessible(true);
            classRefsField = Hessian2Output.class.getDeclaredField("_classRefs");
            classRefsField.setAccessible(true);
            bufferField = Hessian2Output.class.getDeclaredField("_buffer");
            bufferField.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.warning("get Hessian2Output error.");
        }
    }

    static class StringFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new StringFieldSerializer();

        StringFieldSerializer() {
        }

        @Override
        void serialize(AbstractHessianOutput out, GenericObject obj, String field) throws IOException {
            String value = (String)obj.getField(field);
            out.writeString(value);
        }
    }

    static class DoubleFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new DoubleFieldSerializer();

        DoubleFieldSerializer() {
        }

        @Override
        void serialize(AbstractHessianOutput out, GenericObject obj, String field) throws IOException {
            double value = ((Number)obj.getField(field)).doubleValue();
            out.writeDouble(value);
        }
    }

    static class LongFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new LongFieldSerializer();

        LongFieldSerializer() {
        }

        @Override
        void serialize(AbstractHessianOutput out, GenericObject obj, String field) throws IOException {
            long value = ((Number)obj.getField(field)).longValue();
            out.writeLong(value);
        }
    }

    static class IntFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new IntFieldSerializer();

        IntFieldSerializer() {
        }

        @Override
        void serialize(AbstractHessianOutput out, GenericObject obj, String field) throws IOException {
            int value = ((Number)obj.getField(field)).intValue();
            out.writeInt(value);
        }
    }

    static class BooleanFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new BooleanFieldSerializer();

        BooleanFieldSerializer() {
        }

        @Override
        void serialize(AbstractHessianOutput out, GenericObject obj, String field) throws IOException {
            boolean value = (Boolean)obj.getField(field);
            out.writeBoolean(value);
        }
    }

    static class FieldSerializer {
        static final FieldSerializer SER = new FieldSerializer();

        FieldSerializer() {
        }

        void serialize(AbstractHessianOutput out, GenericObject obj, String field) throws IOException {
            Object value = obj.getField(field);
            out.writeObject(value);
        }
    }

    static class ObjectDefinition {
        private final String _type;
        private final String[] _fieldNames;

        ObjectDefinition(String type, String[] fields) {
            this._type = type;
            this._fieldNames = fields;
        }

        String getType() {
            return this._type;
        }

        String[] getFieldNames() {
            return this._fieldNames;
        }
    }
}

